/*
 * Koza's best parse tree only scores 79 points here, so there's some
 * problem with it which I haven't turned up yet...
 */

#include <string.h>
#include <malloc.h>
#include "geppetto.h"
#include "proto.h"

static result *opRight P((int, const object **, void *));
static result *opLeft P((int, const object **, void *));
static result *opMove P((int, const object **, void *));
static result *opIfFoodAhead P((int, const object **, void *));
static result *opBlock P((int, const object **, void *));
static objectList *antTerminals P((NOARGS));
static objectList *antFunctions P((NOARGS));
static int antCaseTerminate P((result *, void *, int));
static void antCaseFitness P((result *, int, int *, double *, double *,
			      void *));
static int antTerminateRun P((int, double, double));
static void *antCaseInit P((int));
static void antDestructor P((NOARGS));

typedef enum antDirection {
  north, east, south, west,
  minDirection=north, maxDirection=west,
} antDirection;

typedef struct antInfo {
  int time, hits;
  antDirection direction;
  int posX, posY;
  char **arena;
} antInfo;

#define antTimedOut(t)		((t) >= 400)
#define minX			0
#define maxX			31
#define minY			0
#define maxY			31
#define foodAt(ra, ax, ay)	((ra)[ay][ax] == '*')
#define antPath(ra, ax, ay)	((ra)[ay][ax] = 'x')

static antInfo antEnv;
static char **arena = 0;
static const char *arenaTemplate[32] = {
  " ***                            ",
  "   *                            ",
  "   *                    o***oo  ",
  "   *                    *    *  ",
  "   *                    *    *  ",
  "   ****o*****       o**oo    o  ",
  "            *       o        *  ",
  "            *       *        o  ",
  "            *       *        o  ",
  "            *       *        *  ",
  "            o       *        o  ",
  "            *       o        o  ",
  "            *       o        *  ",
  "            *       *        o  ",
  "            *       *  ooo***o  ",
  "            o   o*ooo  *        ",
  "            o   o      o        ",
  "            *   o      o        ",
  "            *   *      o*ooo    ",
  "            *   *          *    ",
  "            *   *          o    ",
  "            *   *          o    ",
  "            *   o      ooo*o    ",
  "            *   o      *        ",
  " oo**oo*****o   *               ",
  " *              *               ",
  " *              *               ",
  " *     o*******oo               ",
  " *     *                        ",
  " o     *                        ",
  " o****oo                        ",
  "                                ",
};

static result *
opRight(argc, argv, envp)
int argc;
const object **argv;
void *envp;
{
  antInfo *antp = (antInfo *)envp;

  /* see if it's timed out yet */
  antp->time++;

  /* turn right */
  antp->direction++;
  if (antp->direction > maxDirection)
    antp->direction = minDirection;

  return(resultCreate(dtVoid));
}

static result *
opLeft(argc, argv, envp)
int argc;
const object **argv;
void *envp;
{
  antInfo *antp = (antInfo *)envp;

  /* see if it's timed out yet */
  antp->time++;

  /* turn left */
  antp->direction--;
  if (antp->direction < minDirection)
    antp->direction = maxDirection;

  return(resultCreate(dtVoid));
}

static result *
opMove(argc, argv, envp)
int argc;
const object **argv;
void *envp;
{
  antInfo *antp = (antInfo *)envp;

  /* see if it's timed out yet */
  antp->time++;

  /* move in the proper direction */
  switch (antp->direction) {
  case west:
    antp->posX--;
    if (antp->posX < minX)
      antp->posX = maxX;
    break;
  case east:
    antp->posX++;
    if (antp->posX > maxX)
      antp->posX = minX;
    break;
  case north:
    antp->posY--;
    if (antp->posY < minY)
      antp->posY = maxY;
    break;
  case south:
    antp->posY++;
    if (antp->posY > maxY)
      antp->posY = minY;
    break;
  }

  /* see if there's any food here */
  if (foodAt(antp->arena, antp->posX, antp->posY))
    antp->hits++;
  antPath(antp->arena, antp->posX, antp->posY);

  return(resultCreate(dtVoid));
}

static result *
opIfFoodAhead(argc, argv, envp)
int argc;
const object **argv;
void *envp;
{
  antInfo *antp = (antInfo *)envp;
  int posX, posY;

  /* look in the proper direction */
  posX = antp->posX;
  posY = antp->posY;
  switch (antp->direction) {
  case west:
    posX--;
    if (posX < minX)
      posX = maxX;
    break;
  case east:
    posX++;
    if (posX > maxX)
      posX = minX;
    break;
  case north:
    posY--;
    if (posY < minY)
      posY = maxY;
    break;
  case south:
    posY++;
    if (posY > maxY)
      posY = minY;
    break;
  }

  /* evaluate the proper subexpression */
  return(foodAt(antp->arena, posX, posY) ? objectEval(argv[0], envp) :
	 objectEval(argv[1], envp));
}

static result *
opBlock(argc, argv, envp)
int argc;
const object **argv;
void *envp;
{
  int i;
  result *r;


  /* evaluate arguments */
  i = 0;
  r = 0;
  do {
    if (r)
      resultFree(r);
    r = objectEval(argv[i++], envp);
  } while (!resultIsError(r) && (i < argc));

  /* return the result */
  return(r);
}

static objectList *
antTerminals()
{
  objectList *list;
  operatorSrc *osp;

  list = objectListCreate(4);
  if (list) {

    osp = complexOperatorSrcCreate("right", opRight, dtVoid, 0, 0);
    if (objectListAdd(list, osp)) {
      operatorSrcFree(osp);
      objectListFree(list);
      return(0);
    }

    osp = complexOperatorSrcCreate("left", opLeft, dtVoid, 0, 0);
    if (objectListAdd(list, osp)) {
      operatorSrcFree(osp);
      objectListFree(list);
      return(0);
    }

    osp = complexOperatorSrcCreate("move", opMove, dtVoid, 0, 0);
    if (objectListAdd(list, osp)) {
      operatorSrcFree(osp);
      objectListFree(list);
      return(0);
    }
  }

  return(list);
}

static objectList *
antFunctions()
{
  objectList *list;
  operatorSrc *osp;

  list = objectListCreate(3);
  if (list) {

  osp = complexOperatorSrcCreate("ifFoodAhead", opIfFoodAhead, dtVoid, 2, 2,
				 dtVoid, dtVoid);
  if (objectListAdd(list, osp)) {
      operatorSrcFree(osp);
      objectListFree(list);
      return(0);
    }

    osp = complexOperatorSrcCreate("progn2", opBlock, dtVoid, 2, 2, dtVoid,
				   dtVoid);
    if (objectListAdd(list, osp)) {
      operatorSrcFree(osp);
      objectListFree(list);
      return(0);
    }

    osp = complexOperatorSrcCreate("progn3", opBlock, dtVoid, 3, 3, dtVoid,
				   dtVoid, dtVoid);
    if (objectListAdd(list, osp)) {
      operatorSrcFree(osp);
      objectListFree(list);
      return(0);
    }
  }

  return(list);
}

static void *
antCaseInit(fc)
int fc;
{
  int i;

  /* initialize arena */
  for (i = 0; i < 32; i++)
    strncpy(arena[i], arenaTemplate[i], 33);

  /* initialize variables */
  antEnv.time = 0;
  antEnv.hits = 0;
  antEnv.direction = east;
  antEnv.posX = antEnv.posY = 0;
  antEnv.arena = arena;

  return((void *)&antEnv);
}

static int
antCaseTerminate(rp, envp, fc)
result *rp;
void *envp;
int fc;
{
  antInfo *aip = (antInfo *)envp;

#ifdef DEBUG_ANT
{
  int i;

  for (i = 0; i < 32; i++)
    printf("%s\n", arena[i]);

  printf("Ant Info: hits=%d, time=%d, posX=%d, posY=%d\n", aip->hits,
	 aip->time, aip->posX, aip->posY);

  printf("----------------------------------------------------------------\n");
}
#endif /* DEBUG_ANT */

  return((aip->hits == 89) || (aip->time >= 400));
}

static void
antCaseFitness(rp, fc, hitp, rawp, stdp, envp)
result *rp;
int fc;
int *hitp;
double *rawp;
double *stdp;
void *envp;
{
  antInfo *aip = (antInfo *)envp;

#ifdef DEBUG_ANT
{
  charString *cstr;
  int i;

  cstr = charStringCreate();
  charStringSet(cstr, "Result is ");
  resultToString(rp, cstr);
  charStringPrint(cstr);
  charStringFree(cstr);

  for (i = 0; i < 32; i++)
    printf("%s\n", arena[i]);

  printf("Ant Info: hits=%d, time=%d, posX=%d, posY=%d\n", aip->hits,
	 aip->time, aip->posX, aip->posY);
}
#endif

  *rawp = *hitp = aip->hits;
  if (resultIsError(rp))
    *stdp = 90;
  else
    *stdp = 89 - aip->hits;
}

static int
antTerminateRun(hits, raw, std)
int hits;
double raw;
double std;
{
  return(hits == 89);
}

static void
antDestructor()
{
  free(arena);
}

void
appInitialize(ip)
interface *ip;
{
  int i;
  char *cp;

  /* build a prototype arena for the ants to play in */
  arena = (char **)malloc((sizeof(char)*33 + sizeof(char *))*32);
  cp = (char *)arena + sizeof(char *)*32;
  for (i = 0; i < 32; i++) {
    if (i > 0)
      cp += 33;
    arena[i] = cp;
  }

  interfaceSetFitnessCases(ip, 1);
  interfaceSetTerminalList(ip, antTerminals());
  interfaceSetFunctionList(ip, antFunctions());
  interfaceCaseInitializeFunc(ip, antCaseInit);
  interfaceCaseTerminateFunc(ip, antCaseTerminate);
  interfaceCaseFitnessFunc(ip, antCaseFitness);
  interfaceTerminateRunFunc(ip, antTerminateRun);
  interfaceDestructorFunc(ip, antDestructor);
}

#ifdef OLD_DEBUG_ANT

#include <stdio.h>
#include <ctype.h>
#include "proto.h"

static result *opFoodAhead P((int, const object **, void *));
static char foodChar P((void *));
static void appDump P((NOARGS));
int main P((NOARGS));

static result *
opFoodAhead(argc, argv, envp)
int argc;
const object **argv;
void *envp;
{
  antInfo *antp = (antInfo *)envp;
  int posX, posY;
  result *rp;
  bool bval;

  /* create a result first */
  rp = resultCreate(dtBoolean, bval);
  if (rp) {

    /* move in the proper direction */
    posX = antp->posX;
    posY = antp->posY;
    switch (antp->direction) {
    case west:
      posX--;
      if (posX < minX)
      posX = maxX;
      break;
    case east:
      posX++;
      if (posX > maxX)
      posX = minX;
      break;
    case north:
      posY--;
      if (posY < minY)
      posY = maxY;
      break;
    case south:
      posY++;
      if (posY > maxY)
      posY = minY;
      break;
    }

    /* see if there's any food here */
    resultSetBoolean(rp, foodAt(antp->arena, posX, posY));
  }

  return(rp);
}

static char
foodChar(envp)
void *envp;
{
  result *rp;

  rp = opFoodAhead(0, 0, envp);
  if (!resultIsBoolean(rp))
    return('?');
  if (resultBoolean(rp))
    return('x');
  return(' ');
}

static void
appDump()
{
  int i;

  for (i = 0; i < 32; i++)
    printf("%s\n", arena[i]);
}

int
main()
{
  interface *ip;
  void *envp;
  int quit = 0;
  char buf[16];

  ip = interfaceCreate(appInitialize);
  envp = interfaceCaseInitialize(ip, 0);
  do {
    printf("%c[%3d:%2d] l(eft), r(ight), m(ove), q(uit): ",
	   foodChar(envp), ((antInfo *)envp)->time, ((antInfo *)envp)->hits);
    fflush(stdout);
    fgets(buf, 15, stdin);
    if (isupper(buf[0]))
      buf[0] = tolower(buf[0]);
    switch (buf[0]) {
    case 'l':
      resultFree(opLeft(0, 0, envp));
      appDump();
      break;
    case 'r':
      resultFree(opRight(0, 0, envp));
      appDump();
      break;
    case 'm':
      resultFree(opMove(0, 0, envp));
      appDump();
      break;
    case 'q':
      quit = 1;
      break;
    }
  } while (!quit);

  exit(0);
}
#endif /* OLD_DEBUG_ANT */
#ifdef DEBUG_ANT

#include "program.h"

int main P((int, char *[]));

int
main(argc, argv)
int argc;
char *argv[];
{
  interface *ip;
  void *envp;
  program *pp;
  const char *src = "(ifFoodAhead (move) (progn3 (left) (progn2 (ifFoodAhead (move) (right)) (progn2 (right)  (progn2 (left) (right)))) (progn2 (ifFoodAhead (move) (left)) (move))))";
  int i = 1;

  ip = interfaceCreate(appInitialize);
  envp = interfaceCaseInitialize(ip, 0);

  do {
    if (argc != 1)
      src = argv[i];
    pp = programParse(interfaceTerminalList(ip), interfaceFunctionList(ip),
		      src);
    if (pp == 0) {
      printf("Bad program '%s'!\n", src);
    } else {
      interfaceEval(ip, pp, 100, 0.0);
      programDump(pp, 1);
      programFree(pp);
    }
  } while (++i < argc);

  exit(0);
}
#endif /* DEBUG_ANT */
