C
C	D.E.KNUTH'S RANDOM NUMBER GENERATOR OF
C	"THE ART OF COMPUTER PROGRAMMING", VOL 2, PP. 170-173
C	$Id: rand.f,v 1.1 1993/02/15 09:43:09 joke Exp $
C
        FUNCTION IRN55(IA)
	DIMENSION IA(1)
C	ASSUMING THAT IA(1), ..., IA(55) HAVE BEEN SET UP PROPERLY,
C	THIS SUBROUTINE RESETS THE IA ARRAY TO THE NEXT 55 NUMBERS
C	OF A PSEUDO-RANDOM SEQUENCE, AND RETURNS THE VALUE 1.
	DO 1 I = 1, 24
	  J = IA(I) - IA(I+31)
	  IF (J .LT. 0) J = J + 1000000000
	  IA(I) = J
  1	CONTINUE
	DO 2 I = 25, 55
	  J = IA(I) - IA(I-24)
	  IF (J .LT. 0) J = J + 1000000000
	  IA(I) = J
  2	CONTINUE
	IRN55=1
	RETURN
	END
C
	SUBROUTINE IN55(IA,IX)
	DIMENSION IA(1)
C	THIS SUBROUTINE SETS IA(1), ..., IA(55) TO STARTING
C	VALUES SUITABLE FOR LATER CALLS ON IRN55(IA).
C	IX IS AN INTEGER "SEED" VALUE BETWEEN O AND 999999999.
	IA(55) = IX
	J = IX
	K = 1
	DO 1 I = 1, 54
	  II = MOD(21*I,55)
	  IA(II) = K
	  K = J - K
	  IF (K .LT. 0) K = K + 1000000000
	  J = IA(II)
  1	CONTINUE
C	THE NEXT THREE LINES "WARM UP" THE GENERATOR
	IDUM=IRN55(IA)
	IDUM=IRN55(IA)
	IDUM=IRN55(IA)
	RETURN
	END
C
C	MAIN PROGRAM
C
	DIMENSION IA(55)
	JRAND = 55
C
	CALL IN55(IA,0)
C
	DO 1 I=1,1000
	JRAND = JRAND + 1
	IF (JRAND .GT. 55) JRAND = IRN55(IA)
	U = FLOAT(IA(JRAND)) * 1.0E-9
C
	WRITE(6,'(f10.8)') U
  1	CONTINUE
	END
