#include "genocop.h"

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   evaluate()                                   */
/*                                                                              */
/*           SYNOPSIS          :   float evaluate(X)                            */
/*                                                                              */
/*           DESCRIPTION       :   This function returns the value of the       */
/*                                  function evaluated for the given values of  */
/*                                  the variables.                              */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main(),                                      */
/*                                 optimization().                              */
/*                                                                              */
/*           AUTHOR            :   Tom Logan                                    */
/*                                                                              */
/*           DATE              :   8/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/
float evaluate(X)
VECTOR X;
{
  switch (test_num)
   {
     case 1:  return(X[1]*sin(X[2]) + X[3]*X[3] -12.7*X[4]);
     case 2:  return(X[1]*(70.0-4.0*X[1]) + X[2]*(150.0 - 15.0*X[2])
                     - 100.0 - 15.0*X[1] - 15.0*X[2]);
     case 3:  return(-1.0*(X[1]-3.0)*(X[1]-3.0) - (X[2]-2.0)*(X[2]-2.0));
     case 4:  return(-2.0*X[1]*X[1] - X[2]*X[2] + X[1]*X[2] + 8.0*X[1] + 3.0*X[2]);
     case 5:  return((3.0*X[1] + X[2] - 2.0*X[3] + 0.8)/(2.0*X[1] - X[2] + X[3]) +
             (4.0*X[1] - 2.0*X[2] + X[3])/(7.0*X[1] + 3.0*X[2] - X[3]));
     case 6:  return(0.2*X[1]*X[1] + 0.08*X[2]*X[2] + 0.18*X[3]*X[3] + 
              0.1*X[1]*X[2] + 0.04*X[1]*X[3] + 0.06*X[3]*X[2]);
    default: printf("Invalid test case in eval.c - test case is %f", test_num);
              exit(0);
   }
  return(0);
}
