#include "thesis.h"

void nrerror(error_text)
char error_text[];
{
	fprintf(output,"Numerical Recipes run-time error...\n");
	fprintf(output,"%s\n",error_text);
	fprintf(output,"...now exiting to system...\n");
	exit(1);
}



VECTOR vector(nl,nh)
int nl,nh;
{
	VECTOR v;

	v=(float *)malloc((unsigned) (nh-nl+1)*sizeof(float));
	if (!v) nrerror("allocation failure in vector()");
	return v-nl;
}


IVECTOR ivector(nl,nh)
int nl,nh;
{
	IVECTOR v;

	v=(int *)malloc((unsigned) (nh-nl+1)*sizeof(int));
	if (!v) nrerror("allocation failure in ivector()");
	return v-nl;
}



MATRIX matrix(nrl,nrh,ncl,nch)
int nrl,nrh,ncl,nch;
{
	int i;
	MATRIX m;

	m=(float **) malloc((unsigned) (nrh-nrl+1)*sizeof(float*));
	if (!m) nrerror("allocation failure 1 in matrix()");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(float *) malloc((unsigned) (nch-ncl+1)*sizeof(float));
		if (!m[i]) nrerror("allocation failure 2 in matrix()");
		m[i] -= ncl;
	}
	return m;
}


IMATRIX imatrix(nrl,nrh,ncl,nch)
int nrl,nrh,ncl,nch;
{
	int i;
        IMATRIX m;

	m=(int **)malloc((unsigned) (nrh-nrl+1)*sizeof(int*));
	if (!m) nrerror("allocation failure 1 in imatrix()");
	m -= nrl;

	for(i=nrl;i<=nrh;i++) {
		m[i]=(int *)malloc((unsigned) (nch-ncl+1)*sizeof(int));
		if (!m[i]) nrerror("allocation failure 2 in imatrix()");
		m[i] -= ncl;
	}
	return m;
}

void free_vector(v,nl,nh)
     float *v;
     int nl,nh;
{
          free((char*) (v+nl));
	}

void free_ivector(v,nl,nh)
     int *v,nl,nh;
{
          free((char*) (v+nl));
	}
void free_matrix(m,nrl,nrh,ncl,nch)
     float **m;
     int nrl,nrh,ncl,nch;
{
          int i;

	          for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	          free((char*) (m+nrl));
	}
void free_imatrix(m,nrl,nrh,ncl,nch)
     int **m;
     int nrl,nrh,ncl,nch;
{
          int i;

	          for(i=nrh;i>=nrl;i--) free((char*) (m[i]+ncl));
	          free((char*) (m+nrl));
	}

