#include "thesis.h"

void get_var_order(tot,cart,var_order)
IVECTOR tot, 
        cart;
IMATRIX var_order;
{
  int i;

  for(i=1; i<=tot[0]; i++)
    {
      var_order[i][1] = i;
      var_order[i][2] = 0;
    }

  for(i=1; i<=tot[1]; i++)
    var_order[cart[i]][2] = 1;
}

void find_x1_x2(tot,var_order,x1,x2)
int tot; 
IMATRIX var_order;
                  
IVECTOR x1,       
        x2;       
{
  int i,j=1,k=1;

  for(i=1; i<=tot; i++)
    {
      if(var_order[i][2] == 1)
	x1[j++] = var_order[i][1];
      else
	x2[k++] = var_order[i][1];
    }
}

void find_ac1_ac2(t1,t2,t3,x1,x2,mat,ac1,ac2)
int t1,t2,t3;
IVECTOR x1,x2;
MATRIX  mat,  
        ac1,ac2;
{
  int i,j,k;

  for(i=1; i<=t1; i++)
    for(j=1; j<=t2; j++)
      ac1[j][i] = mat[j][x1[i]];

  for(i=1; i<=t3; i++)
    for(j=1; j<=t2; j++)
      ac2[j][i] = mat[j][x2[i]];
}


void find_lu1_lu2(tot,x1,x2,dom,dom1,dom2)
IVECTOR tot,x1,x2;
VECTOR  dom, 
        dom1,dom2;
{
  int i,j,k;

  for(i=1; i<=tot[1]; i++)
      dom1[i] = dom[x1[i]];

  for(i=1; i<=tot[0]-tot[1]; i++)
      dom2[i] = dom[x2[i]];
}



void find_limits(tot,domains,llim,ulim)
int tot;
MATRIX domains;
VECTOR llim,ulim;
{
  int i;

  for(i=1; i<=tot; i++)
    {
      llim[i] = domains[i][1];
      ulim[i] = domains[i][3];
    }
}



void find_new_in_eq(a1b,a1a2,ll,ul,rc,newin)
VECTOR a1b,   
       ll,ul; 
MATRIX a1a2,  
       newin; 
INDEX rc;
{
  int i,j;

  for(i=1; i<=rc.r; i++)
    for(j=1; j<=rc.c; j++)
      if(j==1)
	newin[i][j] = ll[i] - a1b[i];
      else if(j==rc.c)               
	newin[i][j] = ul[i] - a1b[i];
      else 
	newin[i][j] = 0 - a1a2[i][j-1];
}


void find_org_in_eq(a1_b,a1_a2,vec_d,c1,c2,c1row,a1a2,org_ineq)
VECTOR vec_d,      
       a1_b;       
MATRIX a1_a2,      
       org_ineq,   
       c1,c2;      
int c1row;
INDEX a1a2;        
{
  int i,j;
  VECTOR temp;
  MATRIX mat;

  temp = vector(1,c1row);
  mat = matrix(1,c1row,1,a1a2.c-1);

  mvprod(c1row,a1a2.r,temp,c1,a1_b);
  mmprod(c1row,a1a2.r,a1a2.c-1,mat,c1,a1_a2);

  for(i=1; i<=c1row; i++)
    for(j=1; j<=a1a2.c; j++)
      {
	if (j==a1a2.c)
	  org_ineq[i][j] = vec_d[i] - temp[i];
	else
	  org_ineq[i][j] = c2[i][j] - mat[i][j];
      }
  free_vector(temp,1,c1row);
  free_matrix(mat,1,c1row,1,a1a2.c-1);
}

void initialize(mat,rc)
MATRIX mat;
INDEX rc;
{
  int i,j;
  
  for(i=1; i<=rc.r; i++)
    for(j=1; j<=rc.c; j++)
      mat[i][j] = 0.0;
}


void find_final_mat1(x2,l2,u2,finmat,row,col)
MATRIX finmat;
VECTOR l2,u2;
IVECTOR x2;
int row,col;
{
  int i,j=2;

  for(i=1; i<=row; i++)
    {
      finmat[i][1] = l2[i];
      finmat[i][col] = u2[i];
      finmat[i][j++] = 1.0;
    }
}


void find_final_mat2(newin,r,c,finr,finmat)
MATRIX newin,finmat;
int r,c,finr;
{
  int i,j;

  for(i=1; i<=r; i++)
    {
      for(j=1; j<=c; j++)
	finmat[finr][j] = newin[i][j]; 
      finr++;
    }      
}


void find_final_mat3(orgin,r,c,finr,finmat)
MATRIX orgin,finmat;
int r,c,finr;
{
  int i,j;

  for(i=1; i<=r; i++)
    {
      finmat[finr][1] = MIN;
      for(j=1; j<=c; j++)
	finmat[finr][j+1] = orgin[i][j]; 
      finr++;
    }      
}
