#define _ERRORCHECK_
#include <stdio.h>
#include <math.h>

#define     N       10   /* max number of destinations */
#define     K        10   /* max number of sources */
#define   POP        50   /* max size of population */
#define   licz    2147483647.0
#define	MINUSINF	-99999

#ifndef EXTERN
#define EXTERN extern
#endif

typedef long int Cost; 
typedef struct  {
	int sol[K][N];
	Cost   eval;
	} SOLN;
	
EXTERN SOLN population[POP]; /* population itself */
EXTERN SOLN *pp [POP];       /* population pointer */
EXTERN int par[K][N];       /* parent for mutation */
EXTERN int chd[K][N];       /* child after mutation */
EXTERN int par_a[K][N];      /* first parent for crossover */
EXTERN int par_b[K][N];      /* second parent for crossover */
EXTERN int chd_a[K][N];      /* first child from crossover */
EXTERN int chd_b[K][N];      /* second child from crossover */
EXTERN int dest[N];         /* array of destination values */
EXTERN int sour[K];         /* array of source values */
EXTERN int cost[K][N];      /* array of costs */
EXTERN int initial[K][N];   /* an initial population */
EXTERN Cost eval[POP];      /* array of values of solutions */
EXTERN Cost optimum;      	/* The (known) optimum value */
EXTERN double prob[POP];    /* array of probabilities */
EXTERN int parents[POP];    /* array of parents */
EXTERN int dead[POP];       /* array of dead */

EXTERN int pop;				/* size of population */
EXTERN int k;				/* number of sources */
EXTERN int n;				/* number of destinations */
EXTERN int it;				/* number of iterations for evolution */
EXTERN double sprob;   		/* the selection probability */
EXTERN int reprod;	  	 	/* the number of parents */
EXTERN int cross;           /* the number of crossovers in one generation */
EXTERN int inver;           /* the number of inversions in one generation */
EXTERN int mutat;           /* the number of mutations in one generation */

       /* reprod = inver + mutat + cross */
       
EXTERN unsigned int seed0; /* the starting seed note: int on MacII,  */
