#include <stdio.h>
#include <math.h>
#include <stdlib.h>

#include "pixmon.h"
#define SQR(a) ((a)*(a))

typedef struct complex {
	double x;
	double y;
} complex;


int gm,gd;
int maxx,maxy;

double xfrom;
double xto  ;
double yfrom;
double yto  ;
int    n_iter, n_pixel;

ImgHdr hdr;


int iter(int x,int y,int n)
{
   complex c,z;
   double sx = 0.0, sy = 0.0, distance;

   z.x = z.y = 0.0;
   c.x = xfrom + x * (xto - xfrom) / maxx;
   c.y = yfrom + y * (yto - yfrom) / maxy;
   while (--n > 0 && ((distance=(sx = SQR(z.x)) + (sy = SQR(z.y))) < (double)4))
   {
      z.y = 2*z.x*z.y+c.y;
      z.x = sx-sy+c.x;
   }
/*
   return(n);
*/
   return((int) (128*sqrt(distance)));
}




void main(int argc, char *argv[])
{
   int n;
   unsigned char color;

   INIT_IMGHDR(hdr);
   hdr.type = PIX_DATA | PIX_FLUSH;
   hdr.dx   = hdr.dy = 1;
   hdr.sizelo = 1;

   xfrom = atof(argv[1]);
   xto   = atof(argv[2]);
   yfrom = atof(argv[3]);
   yto   = atof(argv[4]);
   n_iter = atoi(argv[7]);

   maxx = atoi(argv[5]);
   maxy = atoi(argv[6]);
/*
   yto  = yfrom + maxy * (xto-xfrom)/maxx;
*/
   fprintf(stderr,"x=%8.3lf..%8.3lf y=%8.3lf..%8.3lf dx=%3d dy=%3d n=%d\n",
	xfrom, xto, yfrom, yto, maxx, maxy, n_iter);

#ifndef	MODULO
#	define	MODULO	5
#endif
   if ((maxx % MODULO) + (maxy % MODULO) != 0) {	/* normal processing */
	for (hdr.x = 0; hdr.x < maxx; hdr.x++) {
		for (hdr.y = 0; hdr.y < maxy; hdr.y++) {
			n = iter(hdr.x,hdr.y,n_iter);
			color = (unsigned char) (n%255+1);
			fwrite(&hdr, sizeof(hdr),1,stdout);
			fwrite(&color, 1, 1, stdout);
			fflush(stdout);
		}
	}
   }
   else {						/* special effects */
	int	k,l;

	for (k= 0; k < MODULO; k++) {
	for (l= 0; l < MODULO; l++) {
		int	x,y;
#if	FANCY
		for (x = l; x < maxx+l; x+= MODULO) {
			hdr.x =	x % maxx;
			for (y = k+l; y < maxy+k+l; y+= MODULO) {
				hdr.y = y % maxy;
				n = iter(hdr.x,hdr.y,n_iter);
				color = (unsigned char) (n%255+1);
				fwrite(&hdr, sizeof(hdr),1,stdout);
				fwrite(&color, 1, 1, stdout);
				fflush(stdout);
			}
		}
#else
		for (hdr.x = l; hdr.x < maxx; hdr.x+= MODULO) {
			for (hdr.y = k; hdr.y < maxy; hdr.y+= MODULO) {
				n = iter(hdr.x,hdr.y,n_iter);
				color = (unsigned char) (n%255+1);
				fwrite(&hdr, sizeof(hdr),1,stdout);
				fwrite(&color, 1, 1, stdout);
				fflush(stdout);
			}
		}
#endif
	}
	}
   }
}
