#include <fstream.h>
#include <strstream.h>


template <class T>
void scanFile(  T * _rgStart, T * _rgEnd ,		
	      char* _fileN,		
	      char* _inputFile, 
	      unsigned& _popSize,
	      double& _mutRate,
	      unsigned& _gens,
	      unsigned& _locusSize,
	      enum reprodMode & _repType,  
	      unsigned& _uRepArg,
	      float&    _fRepArg,
	      unsigned _genSize,
	      mybool& _gnuplot) {	    // number of generations
		
    char line[40],  foo[40];
    ifstream fin( _fileN );
    while (!fin.eof()) {
	unsigned i;
	fin.getline( line, 40);
	istrstream istr( line, 40 );
	switch ( line[0] ) {
	    case 'i':
	    case 'I':	    // input file
		istr >> foo>> _inputFile;
		break;
	    case 's':	    // startRange. WARNING: don't do it 
	    case 'S':	    // before _gensize has a value
		istr >> foo;
		for (  i = 0; i < _genSize; i ++ )
		    istr >> _rgStart[i];
		 break;
	    case 'e':
	    case 'E':	    // endRange
		istr >> foo;
		for (  i = 0; i < _genSize; i ++ )
		    istr >> _rgEnd[i];
		break;
	    case 'p':
	    case 'P':	    // popSize
		istr>> foo >> _popSize;
		break;
	    case 'm':
	    case 'M':	    // mutation Rate
		istr>> foo >> _mutRate;
		break;
	    case 'G':
	    case 'g':	    // Generations
		istr >> foo >> _gens;
		break;
	    case 'L':
	    case 'l':	    // Generations
		istr >> foo >> _locusSize;
		break;
	    case 'R':
	    case 'r':
		char tmpRepStr[20];
		istr>> foo >> tmpRepStr;
		if ( strcmp( tmpRepStr, "ELITE" ) == 0 ) {
		  _repType = ELITE;
		  istr >> _fRepArg;
		}
		else if  ( strcmp( tmpRepStr, "TOURNAMENT" ) == 0 ) {
		  _repType = TOURNAMENT;
		  istr >> _uRepArg;
		}
		else if  ( strcmp( tmpRepStr, "ROULWHEEL" ) == 0 )
		  _repType = ROULWHEEL;
		break;
	   case 'w':		// Gnuplot Window yes or no
	   case 'W':
		char tmpWinGnu[20];
		istr >> foo >> tmpWinGnu;
		switch ( tmpWinGnu[0] ) {
		    case 'Y':
		    case 'y':
		        _gnuplot= TRUE;
			break;
		    case 'N':
		    case 'n':
			_gnuplot= FALSE;
			break;
		}		// switch tmpWinGnu[0]
	 }			// switch line[0]
    }	// while
};
