// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; c++-electric-colon: t; c-auto-newline: t -*-


// --------------------------- POPSGAp.HPP -----------------------------------
// DESCRIPTION : class to handle a population of fixed-length genomes using a
//               SGA
//		 This p version uses 2 templates, since I learned how 
//               to handle them

// REFERENCES	: Goldbergs book, JJs thesis, and many other things.

// LOG :
// 6-May-94 : Startin, man!
// 8-May-94 : Aniadida la funcion Rank, para poner por orden, y otras 
//            relacionadas
//10-May-94 : Modificaciones para tener en cuenta la nueva clase genSGAv
//	      Y se convierte en polimorfica, toma sha!
//	      Remodificada, para que herede de POPS
//13-May-94 : Aniadidas un par de funciones, mejor fitness y mejor vector
//18-May-94 : Modificado lo de seleccion de ruleta, que parece dar error
//31-May-94 : Adaptado a la notacion del libro sueco; eliminados algunos
//            constructores y reordenados los que hay

#ifndef __POPSGAR_HPP
#define __POPSGAR_HPP

#ifndef __BCPLUSPLUS__
#ident "@(#) popsgar.hpp -- By JJ Merelo "
#endif


#include "bitgene.hpp"
#include "gensgav.hpp"
#include "pops.hpp"			     // base class

enum reprodMode { ELITE, TOURNAMENT, ROULWHEEL }; // Major reproduction modes
	

template <class returnType, class genType>
class popSGAr: public popS<returnType>{
        
public:
    
    
    // constructors and destructors
    popSGAr(unsigned _popSize,  
	    double _mutationRate,
	    unsigned _numParams, 
	    unsigned _sizeParams, 
	    returnType* _rgStart,
	    returnType* _rgEnd);	     // interpreted in different
					     // ways by different constructors

    popSGAr(unsigned _popSize,  
	    double _mutationRate,
	    unsigned _numParams, 
	    unsigned _sizeParams);      
	    
    virtual ~popSGAr();    
    
    
    // look inside functions
    const genType * operator [] ( unsigned _genomeIdx ) const {
	return pop[_genomeIdx];
    };
    
    const genType& bestIndiv( void ) const { return (*pop[ rank[0]]); };
    
    // reproduction overloaded functions
    void            newGeneration(reprodMode _mode,
				  unsigned _operand = 0); // reproduction tournament or RW
    void            newGeneration(reprodMode _mode,
				  float _operand );       // elite reproduction

    // friend declarations
friend ostream& operator << ( ostream& s, const popSGAr & _inPop );

  protected:
				    
    // Roulette wheel and tournament selection functions		    
    virtual void    createRWPool( void); // creates roulette wheel pool, 
					 // according to fitness
    virtual void    createTourPool( unsigned _tournSize );
					     // tournament selection
    virtual void    reproducePool( void);    // reproduces from genePool
    
    // And steady-state functions
    virtual void    eliteRep( float _elitePerc );   
					     // steady state reproduction
    
    
    // genetic operators
    virtual void Clone( unsigned _winner,  unsigned _newPos );	    
					     // clones with mutation
    virtual void Mate(	unsigned _par1,	     // mates them with given mutationRate
		unsigned _par2,		     // places result in the population
		unsigned _sib );  
		
    virtual void eliteMate(
		unsigned _par1,		     // mates them with given mutationRate
		unsigned _par2,		     // places result in the population
		unsigned _sib );	     // does not use genePool

//___________________________________________________________________

  private:

    genType **pop, **genePool;            // current population and genePool
    

    // private funcs
    void allocMem( unsigned _popSize);
	   
};


#include "popsgar.icc"

#endif
