//			GSTREAM.HPP
// DESCRIPTIONS: class that turns gnuplot into a stream, into which you can 
// print as any other

// CAVEATS: Only for UNIX!!!!


#ifndef __GSTREAM_HPP
#define __GSTREAM_HPP

#define MAXGNUTEMP 17		// suggested by JGH

#include <fstream.h>
#include <pfstream.h>

#include <stdio.h>

// particular headers
#include "general.hpp"

typedef enum plotType { LINES, DOTS, POINTS };

class gstream {

public:
    gstream( char* _initStr, plotType _plType = LINES, mybool _flush = TRUE );
    ~gstream();
    
    const char* getTemp() const { return tempGnu; };
    void    reStart( void );

private:

    FILE* gnuFile;		// pipe to gnuplot
    fstream tempF;		// to contain output file
    char tempGnu[MAXGNUTEMP];	// Name of temp file and initString
    char plType;
    mybool flush;
    
    friend gstream& operator << ( gstream&, float );
    friend gstream& operator << ( gstream&, float* );
    friend gstream& operator << ( gstream&, char* );
    void rePlot();		// private func
    
};

#endif
