// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; c++-electric-colon: t; comment-column: 35 -*-
//				GSTREAM.CC
// Implementation of functions for gstream

#include <string.h>

#ifdef _BSD386
#include <unistd.h>
#endif

#include <sys/types.h>		   // To use PID
#include <sys/stat.h>		   // for stat
#include <signal.h>		   // for signal

#include "general.hpp"
#include "gstream.hpp"

#define NUMPOSSFILES   20	   // Max number of files

// signal handling
#ifdef _BSD386
static void sigfunc(int);
#else
static void sigfunc(int ...); // by JGH
#endif

//-----------------------------------------
gstream::gstream(char* _initStr, 
		 plotType _plType,  
		 mybool _flush){
// --	Initializes the stream
//	flush=TRUE means that the file will be reread and replot every time
// ----------------------------------------
    
    // signal trapping
    signal(SIGTERM, sigfunc); // added JGH
    signal(SIGINT, sigfunc);  // added JGH
    signal(SIGHUP, sigfunc);  // added JGH

    gnuFile = popen( "gnuplot", "w" ); // open pipe to gnuplot
    if (!gnuFile) {
	cerr << "gnuPlot is not present or whatever other circunstance\n";
	exit(1);
    }    
    fprintf( gnuFile, "%s\n", _initStr );
    
    // find a name based on the process PID, plus a random number
    // suggested by JGH
    unsigned procnum = getpid();
    struct stat dummy;
    do {	  
	sprintf( tempGnu, "gnu.tmp%d.%d", procnum, myrand(NUMPOSSFILES) ); 
				   // if there are many, there may be
				   // conflicts
    } while ( stat( tempGnu, &dummy ) == 0 );
				   // while the file exists
	  
    tempF.open( tempGnu, ios::out); 
        
    // assign to instance variables
    switch ( _plType ) {
	  case LINES : plType = 'l'; break;
	  case DOTS : plType = 'd'; break;
	  case POINTS : plType = 'p'; break;	
    }

    flush = _flush;
    if (flush)
	  tempF.close();	   // to create it, but not write
}


//-----------------------------------------
gstream::~gstream( ){
// -- Closes everything and removes things
// ----------------------------------------
    const char constGnu[MAXGNUTEMP] = tempGnu; // little trick to make vars const
    if (!flush)
	  tempF.close();
    pclose( gnuFile );		   // closes pipe first, to not have trouble 
				   // with non-existing files
    remove( constGnu );		   // removes the disk file

}


//-----------------------------------------
void gstream::rePlot( ){
// -- Plots whatever is in the file
// ----------------------------------------
    fprintf( gnuFile, "plot \"%s\" w %c\n",  tempGnu, plType );
    fflush( gnuFile);			// flushes to force output
}


//-----------------------------------------
void gstream::reStart( void ) {
// -- Empties the buffer, and starts all over again
//-----------------------------------------  
    
    if ( !flush ) {
	tempF.close();
	rePlot();
	tempF.open( tempGnu, ios::out ); // puts pointer at the beginning
    }
    else {
	tempF.open( tempGnu, ios::out ); // puts pointer at the beginning
	tempF.close();			 // of the file and closes it
    }  
    
}


//----------------------------------------------
#ifdef _BSD386
void sigfunc(intsig) {
#else
void sigfunc(int sig, ...) { // added JGH
#endif
// -- cleans up if ctrl-c or other is pressed
//----------------------------------------------

    // compute names from pid
    unsigned numproc = getpid();
    char tempGnu[MAXGNUTEMP];
  
    for ( unsigned i= 0; i < NUMPOSSFILES; i ++ )  {
	sprintf( tempGnu, "gnu.tmp%d.%d", numproc, i ); 
	remove(tempGnu );	   // unlink temporary file. 
	                           // Does not matter if it does not exist 
    }
    exit(1); // exit closes files, thus getting rid of gnuplot.
}


//----------------------------------------------
gstream& operator << ( gstream& _gnu, float _out){
// -- output functions
//----------------------------------------------    
    if ( _gnu.flush == TRUE )
	  _gnu.tempF.open( _gnu.getTemp(), ios::out|ios::app);	    
				// open for output && append
    _gnu.tempF << _out << "\n";
    
    if ( _gnu.flush == TRUE ) {
		_gnu.tempF.close();
		_gnu.rePlot();
    }  
}

//----------------------------------------------
gstream& operator << ( gstream& _gnu, float* _out){
// --	output functions; takes only the first 2 elements of the
//	array
//---------------------------------------------- 
    if ( _gnu.flush == TRUE )   
	  _gnu.tempF.open( _gnu.getTemp(), ios::out|ios::app);	    
				// open for output && append
    _gnu.tempF << _out[0] << " " << _out[1] << "\n"; 
				// cannot have more than 2 comps
    if ( _gnu.flush == TRUE ) {
		_gnu.tempF.close();
		_gnu.rePlot();  
    }
}


//----------------------------------------------
gstream& operator << ( gstream& _gnu, char* _out){
// -- output functions
//----------------------------------------------    

    if (_gnu.flush == TRUE )
	  _gnu.tempF.open( _gnu.getTemp(), ios::out|ios::app);	    
					    // open for output && append
    _gnu.tempF << _out << "\n";		    // cannot have more than 2 comps
    if (_gnu.flush == TRUE ) {
		_gnu.tempF.close();
		_gnu.rePlot();  
    }
}

