// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; c++-electric-colon: 1; c-auto-newline: 1; comment-column: 35 -*-


//			GENSGAV.HPP
// DESCRIPTION: same as gensga.hpp, but with variable range for each locus
//		in the cromosome.


#ifndef __GENSGAV_HPP
#define __GENSGAV_HPP

#ifndef __BCPLUSPLUS__
#ident "@(#) gensgav.hpp -- by J. J. Merelo"
#endif

#include "genvar.hpp"

// useful but not class functions
unsigned char deGray( unsigned char _deG ); // converts from Gray to binary



template <class returnType>
class genSGAv: public genVar {


public:


    // constructors and destructors.
    virtual ~genSGAv () {
	delete[] rangeA;
	delete[] rangeStartA;
    }
    
    genSGAv();
    genSGAv(unsigned _numAlleles, 
	    unsigned _sizeAllele, 
	    returnType *_rgStart=0, 
	    returnType *_rgEnd=0 );	     // 0 is for dummy purposes
	    
	    
    // Unary constructors, from only 1 parent
    genSGAv(const genSGAv &_genSGAv, 
	    double _mutationRate, 
	    unsigned _genTr1= 0, unsigned _genTr2 = 0 );
					     // cloning with mutation and transposition
    
    genSGAv(const genSGAv &genSGAv1, 
	    const genSGAv &genSGAv2, 
	    unsigned _startPoint, unsigned _endPoint, 
	    float _mutationRate)
      :genVar( genSGAv1, genSGAv2, _startPoint, _endPoint, _mutationRate ) { 
	  allocRanges2( genSGAv1.rangeStartA, genSGAv1.rangeA );	
      };				     // 2-pt xOver + mutation

    genSGAv(const genSGAv& _inGen );	     // copy constructor
  

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=- 
//   Common functions to all the "gene" hierarchy
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

    // "info" functions, and overloaded operators
    const returnType	operator [] (unsigned _idx) const;

    // getLength is directly inherited from genVar

    operator returnType * ( void ) const;
				   // conversion operator

    // Particular info function
    // now functions for fancy Gray decoding
    const returnType	deGray	    ( unsigned _idx ) const;
   
    // Friend declaration
friend ostream& operator << ( ostream& s, const genVar & _inGen );
    

private:

    returnType *rangeStartA, *rangeA; // beginning of range and range
	
	
    void allocRanges(returnType *_rgStart, 
		     returnType *_rgEnd );
	    
    void allocRanges2(returnType *_rgStart, 
		      returnType *_rg );
				   // same as before, but using real ranges
						
	    
};

#include "gensgav.icc"		   // templates and inlines, hidden
				   // from prying eyes


#endif
