// ------------------------------ GENERAL.HPP	----------------------
// Includes #defs and whatnots used from everywhere in the program

#ifndef _GENERAL_HPP
#define _GENERAL_HPP

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>

#include <iostream.h>


// general type definition
typedef enum mybool { FALSE=0, TRUE };
typedef char fileName[100];

// portable definition of a random generation function
#ifdef __BCPLUSPLUS__
#define myrand( x ) random( x )
#elif defined( _BSD386 )
#define myrand( x ) ((int) random() % (x) ) // by JGH
#else
#define myrand( x ) ((int) lrand48() % (x))
#endif

// portable definition of random seed generator
#ifdef __BCPLUSPLUS__
#define mysrand()	srand( (unsigned) time( (time_t) 0 ) )
#elif defined( _BSD386 )
#define mysrand( x )    srandom( (unsigned) time( (time_t) 0 ) ) // by JGH
#else
#define mysrand()	srand48( (unsigned) time( (time_t) 0) )
#endif


// portable definition of the directory separator
#ifdef __MSDOS__
#define SEP '\\'
#else
#define SEP '/'
#endif


// templates galore

// ---------------------------------------------
template <class swapType>
void swap( swapType& _s1, swapType& _s2 ) {
// -- swaps contents of the two variables
// -----------------------------------------------
    swapType tmp = _s1;
    _s1 = _s2;
    _s2 = tmp;
}

#endif // _GENERAL_HPP
