// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; c++-electric-colon: t; c-auto-newline: t -*-
//                             BITGENE.CC	
// Implementation of some functions for bitGene class

#include "bitgene.hpp"                    


// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
bitGene::bitGene(const bitGene& bitGene1, 
		 double _mutationRate, 
		 unsigned _genTr1, 
		 unsigned _genTr2) 
	: rawGene( bitGene1, _mutationRate), 
	  bitSize( bitGene1.bitSize ), 
	  numLoci( bitGene1.numLoci ) 
{
// -- Constructor; only works if _genTr* are different
//    from 0
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
    if ( _genTr1 || _genTr2 ) {
	  transposeChunk( _genTr1*bitSize, _genTr2* bitSize, bitSize );
      }  
	  
}


// --------------------------------------
unsigned bitGene::bit ( unsigned _idx ) const {
// -- _idx is the bit index, returns 0 or 1
// ----------------------------------------
    unsigned bitInByte = _idx% BITSINBYTE;
    unsigned idxByte = _idx / BITSINBYTE;
    return getStr(idxByte)&&Wgts[bitInByte];
}


// ----------------------------------------------------------------
unsigned bitGene::getValue ( unsigned _idx ) const {
// -- Extract value of gene number _idx
// -----------------------------------------------------------------
    
    int startPoint = _idx*bitSize;
    int endPoint = (_idx+1)*bitSize;
    
    long Weight = 1;		    // multiply numbers by this
    long result = 0;

    for ( int i = endPoint -1; i >= startPoint; --i ) {
	unsigned bitInByte = i% BITSINBYTE;
	unsigned idxByte = i / BITSINBYTE;
	result += 
	  Weight *((getStr(idxByte)&Wgts[bitInByte+1]) >>(LASTBYTEN -bitInByte) );
	Weight <<=1;
    }

    return result;
}


//-----------------------------------------------------------------------
// Conversion operators
//---------------------

//-----------------------------------------------------
bitGene:: operator unsigned * ( void ) const {
// -- Standard conversion to unsigned vector
//-----------------------------------------------------

    unsigned * tmpArr = new unsigned[ numLoci ];
    for ( unsigned i = 0; i < numLoci; i ++ )
      tmpArr[i] = getValue( i );
    return tmpArr;
}


//-----------------------------------------------------
bitGene::operator char * ( void ) const {
// -- Standard conversion to a string of digits
//-----------------------------------------------------

    char *tmpStr = new char[ numLoci ];
    strcpy( tmpStr, "" );
    for ( unsigned i = 0; i < numLoci; i ++ )
      sprintf( tmpStr, "%s%d", tmpStr, getValue( i ) );
    return tmpStr;
}
    

// -----------------------------------------------------------------------
// Friendly operators
// ------------------

// -----------------------------------------------------------------------
ostream& operator << ( ostream& s, const bitGene & _inGen ) {
// --	to print a rawGene to stdout
// -----------------------------------------------------------------------

    for ( unsigned long i = 0; i < _inGen.getLength(); i ++ ) 
	s << _inGen[i] << " ";
	
    return s;
}

