// -----------------------------------	POPS.HPP -----------------------------------
// DESCRIPTION :    class to handle a population of fixed-length genomes using a SGA
//		    Several classes inherit from it, depending on the type of genome

// REFERENCES	: Goldbergs book, JJs thesis, and many other things.

// LOG :
// 6-May-94 : Startin, man!
// 8-May-94 : Aniadida la funcion Rank, para poner por orden, y otras relacionadas
//10-May-94 : Modificaciones para tener en cuenta la nueva clase genSGAv
//	      Y se convierte en polimorfica, toma sha!



#ifndef __POPS_HPP
#define __POPS_HPP

#ifndef __BCPLUSPLUS__
#ident "@(#) pops.hpp -- By JJ Merelo "
#endif

#include "general.hpp"				  // para swap

template <class returnType>
class popS{

public:

    // constructors and destructors
    popS( unsigned _popSize,  double _mutRate );
	
    virtual ~popS();    
	    
    // "peeping Tom" functions
    unsigned	getPopSize	( void) const { return popSize; };
    returnType	getFitness	( unsigned _idx ) const { return fitness[_idx];};
    
    
    // assignation functions
    void	setFitness(unsigned _idx, 
			   returnType _value ) { 
      (_idx < popSize)?(fitness[_idx] = _value):0;
    }
       
       
    // "best guy" functions
    unsigned	index2rank( unsigned _idx ) const { // return the genome whose fitness
	return rank[_idx];			    // is in _idx_ position
    }
    unsigned	index2best( void) const { return rank[0];}
				                  // same, with the best
    returnType	bestFitness( void ) const { return fitness[rank[0]]; };


    // unary operator functions
    void        apply1transpose( float _trFreq ) { transposeFreq = _trFreq; };
    void        apply1clone( float _cloneFreq ) { cloneFreq = _cloneFreq; };

protected:
    returnType*		fitness;		  // array of fitness for each individual
    unsigned *		rank;			  // rank according to fitness
    unsigned		popSize;		  // population size
    double		mutationRate;		  // rate of mutation
    double              transposeFreq;            // frequency of transposition operator
    double              cloneFreq;		  // frequency for cloning operator

    // selection and other population functions
    void	    Rank();                       // orders according to fitness
    
					    
    virtual void    createRWPool( void) = 0; // creates roulette wheel pool, 						             // according to fitness
    virtual void    reproducePool( void) = 0;	  // reproduces from genePool
    virtual void    eliteRep( float _elitePerc ) = 0;   
						  // steady state reproduction
    virtual void    createTourPool( unsigned _tournSize ) = 0;
                                                  // tournament selection
    
    // genetic operators
    virtual void    Clone( unsigned _winner,  unsigned _newPos ) = 0;	    
                                                  // clones with mutation
    virtual void Mate(unsigned _par1,		  // mates them with given mutationRate
		      unsigned _par2,		  // places result in the population
		      unsigned _sib ) = 0;  
		
    virtual void eliteMate(unsigned _par1, // mates them with given mutationRate
			   unsigned _par2, // places result in the population
			   unsigned _sib ) = 0;	// does not use genePool
	   
};

#include "pops.icc"

#endif
