// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; c++-electric-colon 1; c-auto-newline 1 -*-

// GENVAR.HPP : Variable length genotype base class
//              But lately descends from rawgene.hpp

#ifndef __GENVAR_HPP
#define __GENVAR_HPP

#include "general.hpp"
#include "rawgene.hpp"

// definition of enumerated types
enum varLenOpMode { DUP, KILL, RANDINC };


// ---------------------------------------------------------------------------
// -------------------------- Class definition -------------------------------

class genVar: public rawGene {


public:
    // several constructors, and one destructor

    genVar( void ) {}; 		// default constructor


    // more or less random constructors
    genVar(unsigned _numAlleles, 
	   unsigned _sizeAllele );

    genVar(char *_str, 
	   unsigned _numAlleles, 
	   unsigned _sizeAllele )
      :rawGene( _str ) {
	  initSize( _sizeAllele );
      };
	
    genVar(char *_str, 
	   unsigned _length, 
	   float _mutationRate )
      :rawGene( _str, _length, _mutationRate ), size( 1 ) {};
	
	
    // "binary" constructors, from two loving parents
    genVar( genVar &genVar1, genVar &genVar2,
		double xOverRate, double MutationRate )
      :rawGene( genVar1, genVar2, xOverRate, MutationRate ) { 
	initSize( genVar1.getSize() ); 
      }; 
					// normal reproduction
    genVar(genVar &genVar1, genVar &genVar2,
	   double xOverRate, double MutationRate, 
	   double killRate, double dupRate );
		
    genVar( genVar &genVar1, genVar &genVar2, double xOverRate )
      :rawGene( genVar1, genVar2, xOverRate ) {
	initSize( genVar1.getSize() ); 
      };
	
    genVar( genVar & _genVar1, genVar & _genVar2, 
	   unsigned _startPoint, unsigned _endPoint, 
	   double _mutationRate)
      :rawGene( _genVar1,  _genVar2, _startPoint, _endPoint, _mutationRate ) { 
	initSize( _genVar1.getSize() ); 
      };				// 2-point crossover
	
	
    // "unary" constructors, from batchelor parent or from an amoeba
    genVar( genVar &genVar1, double MutationRate)
      :rawGene( genVar1, MutationRate ) {
	initSize( genVar1.getSize() );
      };
	
    genVar( genVar &genVar1, double MutationRate, 
	   double killRate, double dupRate);
	
    genVar( genVar &genVar1, varLenOpMode _modeOp, 
	   unsigned _geneIdx = 0, double _mutationRate = 0);	
                                       // creates a new genome using one
				       // of 3 modes; using _geneIdx if
				       // needed and _mutationRate

    // destructor
    ~genVar() {};
	
    // common interface
    virtual unsigned getLength() const { return getNumAlleles();}

    // Friend declaration
    friend ostream& operator << ( ostream& s, const genVar & _inGen );


// -------------------------------------------------------------------

protected:


    // protected methods
    void initSize( unsigned _sizeAllele);
    // underground constructor
					
	
    // protected info functions
    unsigned long getMax4Size( void ) const { return maxForSize;};
    unsigned	  getSize() const		{return size;} ;
    unsigned 	getNumAlleles( void ) const
      { return getNumBytes()/size;} ;

    // other functions
	
    void 	  getAllele( unsigned idx, char* _inStr ) const;
    const char*	  getAllele( unsigned idx) const;

    // variable length functions
    void 	addAllele(void );
    void 	killAllele( unsigned _pos );
    void 	dupAllele( unsigned _pos, double MutationRate );

// --------------------------------------------------------------------

private:
    
    unsigned size;		// size of each allele, in bytes
    unsigned long maxForSize;   // max number code-able with this locus size
				// *WARNING* Number of bytes for this depends
				// on the OS and compiler
	
};

typedef genVar* pGenVar;


#endif
