// -*- mode: c++; c-indent-level: 4; c++-member-init-indent: 8; c++-electric-colon: t; c-auto-newline: t -*-

//				BITGENE.HPP
// DESCRIPTION: Inherits from rawgene, and loci are described by its length in bits.
// All loci have the same length, and they are decoded to unsigned integer numbers.


// LOG 
// 24-May-94:   Comenzando
// 27-May-94:	Siguiendo, cambio de todo siguiendo las reglas del libro tan 
//              chulo que me he ftpeao... Adaptacion a los cambios 
//              correspondientes de la clase base rawgene
//              Ademas, aniadido el constructor de copia y la salida estandar
//  2-Jun-94:   Aniadida otra conversion estandar: a cadena


#ifndef	__BITGENE_HPP
#define __BITGENE_HPP


#include "rawgene.hpp"			    // base class


class bitGene: public rawGene {
					    
public:

    bitGene() {};
    virtual ~bitGene() {};
    
    // more or less random constructors
    bitGene(unsigned _numLoci,unsigned _bitSize )
      :rawGene( _bitSize*_numLoci/BITSINBYTE + 1), 
       bitSize( _bitSize), 
       numLoci(_numLoci) {};

    bitGene(unsigned _numLoci, unsigned _bitSize,
	    void* dummy1, void* dummy2)
      :rawGene( _bitSize*_numLoci/BITSINBYTE + 1), 
       bitSize( _bitSize), 
       numLoci(_numLoci) {};               // similar to genSGAv, dummy ctor
    
    
	
    // "binary" constructors, from two loving parents
    bitGene(bitGene &bitGene1, 
	    bitGene &bitGene2, 
	    unsigned _startPoint, 
	    unsigned _endPoint, 
	    double _mutationRate)
      : rawGene( bitGene1, bitGene2, _startPoint, _endPoint,  _mutationRate), 
        bitSize( bitGene1.bitSize ), 
        numLoci( bitGene1.numLoci ) {};	      // 2-point crossover
    
    // "unary" constructors, from batchelor parent or from an amoeba
    // including transposition
    bitGene(bitGene& bitGene1, double _mutationRate, 
	    unsigned _genTr1= 0, unsigned _genTr2 = 0); 
                                              // Transposition not done by default
   
    // "unary" constructors, from batchelor parent or from an amoeba, 

    bitGene( bitGene& bitGene1, double _mutationRate)
      : rawGene( bitGene1, _mutationRate), 
        bitSize( bitGene1.bitSize ), 
       numLoci( bitGene1.numLoci ) {};

    // copy constructor
    bitGene( bitGene& newBitGene )
      : rawGene( newBitGene ),                // Calls rawGene copy-ctor
        bitSize( newBitGene.bitSize ),
        numLoci( newBitGene.numLoci ) {};
	
    // info functions
    virtual unsigned getLength() const { return numLoci; };
                                          // "Length" is the number of possible
                                          // genome indices

    unsigned bit ( unsigned _idx ) const; // _idx is the bit index, returns 0/1
    unsigned operator [] ( unsigned _idx ) const { return getValue( _idx );};
					  // returns gene value

    // standard conversion
    operator unsigned * ( void ) const;
    operator char*      ( void ) const;
    

    // "friendly" functions
    friend ostream& operator << ( ostream& s, const bitGene & _inGen );
	
	
private:
    unsigned bitSize; 		              // number of bits per locus, 
    unsigned numLoci;			      // number of loci

    unsigned getValue( unsigned _idx ) const;
    
};

#endif
