/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: stuff.h                                             *
;************************************************************/

#include <stdio.h>
#include <math.h>
#include <varargs.h>

/* Returns the maximum of a list of doubles. Can have
   a variable number of arguments. */

double maxx(va_alist)
va_dcl
{
	va_list pvar;
	register int i;
	int count;
	double maximum, temp;

	va_start(pvar);
	count = va_arg(pvar, int);
	maximum = va_arg(pvar, double);
	for (i = 1; i < count; i++)
	{
		temp = va_arg(pvar, double);
		if (temp > maximum) maximum = temp;
	}
	va_end(ap);
	return(maximum);
}


/* Returns the average^2 of a list of doubles. Can have
   a variable number of arguments. */


double avep(va_alist)
va_dcl
{
	va_list pvar;
	register int i;
	int count;
/*	double power, result;*/
	double result;

	va_start(pvar);
/*	power = va_arg(pvar, double);*/
	count = va_arg(pvar, int);
	result = 0.0;
	for (i = 1; i <= count; i++)
	{
		result = result + va_arg(pvar, double);
	}
	va_end(ap);
/*	result = pow(result/(double)count, power);*/
	result = pow(result/(double)count, 2.0);
	return(result);
}
