/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: shuffle.c                                           *
;************************************************************/

#include "header.h"
  
/* Copies individual i in the old population to j in the new population.
   Must make sure to copy the value array location now, since that maintains
   useful evaluation information. */

void copy_individual (i, j)
int i, j;
{
   int x;

   c_value[j] = o_value[i];
   for (x = 1; x <= length; x++) c[j][x] = o[i][x];
}
 
/* Copy the old population to the new based on the shuffle array.*/

void copy_population ()
{
   int i;
   for (i = 1; i <= size; i++) copy_individual(sh[i], i);
}

/* Swap elements in the shuffle array */

void swap (i, j)
int i, j;
{
   int temp;
   
   temp = sh[i];
   sh[i] = sh[j];
   sh[j] = temp;
}

/* Shuffle the shuffle array - in order to get a new order
   for the clones in the new population. The shuffle array
   should have been set from the selection function. The
   goal is to have no position dependencies.*/

void shuffle ()
{
   int i;
   int myrand();

   for (i = 1; i <= size; i++) swap(i, myrand(size));
}

