/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: run.c                                               *
;************************************************************/

#include "header.h"

/* Top level function call. Runs the GA n times, opening
   various output files. */

void run (population_size, number_of_bits, points, n, logfile)
int population_size, number_of_bits, points, n;
char logfile[];
{
   char online[10], offline[12], converge[10], bests[10], reeval[10];
   FILE *logfp, *onlinefp, *offlinefp, *convergefp, *bestfp, *reevalfp;
   int i;

   logfp = fopen(logfile, "w");

   for (i = 1; i <= n; i++) {

        /* Open a files for statistics. For now this
	   code is commented out to skip the statistics.
	   If you want statistics, remove the comment
	   symbols. Also see the fclose statements
	   below, and geval.c */

        /*
	sprintf(online, "online.%d", i);
	onlinefp = fopen(online, "w");

	sprintf(offline, "offline.%d", i);
	offlinefp = fopen(offline, "w");

	sprintf(converge, "converge.%d", i);
	convergefp = fopen(converge, "w");

	sprintf(bests, "best.%d", i);
	bestfp = fopen(bests, "w");

	sprintf(reeval, "reeval.%d", i);
	reevalfp = fopen(reeval, "w");
	*/

        /* This replaces the fopens above. Comment out
	   this section if you want statistics. */

        onlinefp = NULL;
	offlinefp = NULL;
	convergefp = NULL;
	bestfp = NULL;
	reevalfp = NULL;

	/* Perform GA search. */

	ga_search(population_size, number_of_bits, points,
		  logfp, onlinefp, offlinefp, convergefp, bestfp, reevalfp);

	/* Print the result in the log file. */

	printf("Experiment #%d\n", i);
	printf("Individual ");
	show_best_individual();
	printf(" found in %d evaluations with score %f\n", evals, best);

	/* Since there are no statistics at this time,
	   this code is commented out. Remove the comment
	   symbols if you want comments. See the note above. */

	/*
	fclose(onlinefp);
	fclose(offlinefp);
	fclose(convergefp);
	fclose(bestfp);
	fclose(reevalfp);
	*/
   }
   fclose(logfp);
}
