/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: mutate.c                                            *
;************************************************************/

#include "header.h"

/* The actual jump.*/

int jump ()
{
   double ssrand();

   return((int)(floor (log(ssrand()) / log_m_rate)));
}

/* Randomly select a bit and flip it. This is different from selecting
   a bit, and then randomly filling that bit location with a 1 or 0!
   The population is considered to be a linear sequence of bits. */

void flip_bit (bit, i)
int bit, i;
{
	c_value[i] = -1.0;
	if (c[i][bit] == 0) {
		c[i][bit] = 1;
	}
	else	c[i][bit] = 0;
}

/* Do mutation.
   bit = marks the picked bit NOT mutated in the last generation.
*/

void mutate ()
{
	int bits, i, jump();

	i = 1;
	bits = length - 1;
	while (i <= size) {
		if (bit <= bits) {
			flip_bit(bit, i);
			bit = bit + jump();
		}
		else {
			bit = bit - bits;
			i++;
		}
	}
}
