/************************************************************
;                                                           *
;  William M. Spears					    *
;  Navy Center for Applied Research in AI                   *
;  Naval Research Laboratory                                *
;                                                           *
;  This software is the property of the Department of the   *
;  Navy. Permission is hereby granted to copy all or any    *
;  part of this program for free distribution, however      *
;  this header is required on all copies.		    *
;                                                           *
; File: ga.c                                                *
;************************************************************/

#include "header.h"

/* Marker to indicate when a run of the GA is done. */

int done;

/* Essentially your standard generation GA. The "done" flag
   is set here when you are finished. This is based on the
   termination criterion. The convergence function can be used
   to exit, allowing restarts in the function "ga_search". */

void run_ga (pop_size, bits, points, onlinefp,
	     offlinefp, convergefp, bestfp, reevalfp)
int pop_size, bits, points;
FILE *onlinefp, *offlinefp, *convergefp, *bestfp, *reevalfp;
{
	int i;

	time_keeper();
	fitness(onlinefp, offlinefp, convergefp, bestfp, reevalfp);
	offspring();
	for (i = 0; !((done = termination()) || convergencep()); i++) {
/*	for (i = 0; !(done = termination()); i++) {*/

	        report();
		ga_select();
		shuffle();
		swap_pops();
		copy_population();
		mutate();

		if (points == 0) {
		  uniform_cross_population();
		}
		else cross_population(points);

		time_keeper();
		fitness(onlinefp, offlinefp, convergefp, bestfp, reevalfp);
		offspring();
	}
}

/* Initialize GA variables and run GA until done. The "done"
   flag allows the GA to restart as often as needed to find
   the solution. */

void ga_search (pop_size, bits, points, logfp,
		onlinefp, offlinefp, convergefp, bestfp, reevalfp)
int pop_size, bits, points;
FILE *logfp, *onlinefp, *offlinefp, *convergefp, *bestfp, *reevalfp;
{
	int i;

	done = 0;
	init_ga_variables(pop_size, bits);
	init_ga_population();

	for (i = 1; !done; i++) {
	        iteration = i;
		printf("Iteration %d of GA at %d generations\n", i, gen_time);
		run_ga(pop_size, bits, points, 
		       onlinefp, offlinefp, convergefp, bestfp, reevalfp);
		if (!done) reinit_everything();
	}

	fprintf(logfp, "Individual ");
	fshow_best_individual(logfp);
	fprintf(logfp, " with score %f found in %d evaluations and %d iterations.\n",
			best, evals, --i);
	fflush(logfp);
}
