function trkplot(s,u,fig,flag)
% TRKPLOT Draws truck.
%   This function is referred to in Chapter 5.
%
% TRKPLOT(X,U)
%   X - Current state of truck.
%   U - Steering angle.
% Plots truck.
%
% TRKPLOT(X,U,'save')
% Plots truck on existing plot.
%
% The state X is = [horizontal position;
%                   vertical position;
%                   angle of trucks body];
%
% Angles are in radians.
%
% SEE ALSO: trukplot, truksim, trukcon1, trukcon2

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

% CONSTANTS
L = 5;     % Truck length
W = 3;     % Truck width

% STATE
pos = s(1)+sqrt(-1)*s(2);
phi = s(3)-pi/2;

% PLOTTING
% ========

% AXIS (IF NECESSARY)
if flag,

  if flag==1,

% CREATE TRUCK
   figure(fig);
   truck = [0 0 -L -L 0]+i*[-W/2 W/2 W/2 -W/2 -W/2];
   h1=line('xdata',real(pos+truck*exp(i*phi)),...
           'ydata',imag(pos+truck*exp(i*phi)),'color','y',...
           'erasemode','xor');
   wheel = [1 -1]*exp(-i*u)-L;
   h2=line('xdata',real(pos+wheel*exp(i*phi)),...
           'ydata',imag(pos+wheel*exp(i*phi)),'color','y',...
           'erasemode','xor');
   set(fig,'userdata',[h1,h2]);
   hold on;
  else
   h=get(fig,'userdata');
   truck = [0 0 -L -L 0]+i*[-W/2 W/2 W/2 -W/2 -W/2];
   set(h(1),'xdata',real(pos+truck*exp(i*phi)),...
            'ydata',imag(pos+truck*exp(i*phi)),'color','y');
   wheel = [1 -1]*exp(-i*u)-L;
   set(h(2),'xdata',real(pos+wheel*exp(i*phi)),...
            'ydata',imag(pos+wheel*exp(i*phi)),'color','y');
   figure(fig);
  end

else

% UPDATE TRUCK AND WHEEL OBJECTS
  h=get(fig,'userdata');
  truck = [0 0 -L -L 0]+i*[-W/2 W/2 W/2 -W/2 -W/2];
  set(h(1),'xdata',real(pos+truck*exp(i*phi)),...
           'ydata',imag(pos+truck*exp(i*phi)),'color','y');
  wheel = [1 -1]*exp(-i*u)-L;
  set(h(2),'xdata',real(pos+wheel*exp(i*phi)),...
           'ydata',imag(pos+wheel*exp(i*phi)),'color','y');
end

