% Stage 5 for Truck Demonstration

% Copyright (c) 1993 by PWS Publishing Company

set([f1,info_win],'vis','off');
set(info_str,'string','');

delete(get(f2,'chil'));
delete(get(f3,'chil'));
delete(get(f4,'chil'));
delete(get(f5,'chil'));
set(f2,'name','Horizontal Position Response','pos',[10,250,305,205]./scrn);
set(f3,'name','Vertical Position Response','pos',[10,10,305,205]./scrn);
set(f4,'name','Truck Angle Response','pos',[325,10,305,205]./scrn);
set(f5,'name','Steering Angle Response','pos',[325,250,305,205]./scrn);

figure(f2);
plot([t0 T],[s0(1) S(1,:)])
hold on
plot([t0 t1],[50 50],':')
hold off
xlabel('Time (Seconds)')
ylabel('Horizontal Position (Meters)')
grid

figure(f3);
plot([t0 T],[s0(2) S(2,:)])
hold on
plot([t0 t1],[0 0],':')
hold off
xlabel('Time (Seconds)')
ylabel('Vertical Position (Meters)')
grid

figure(f4);
plot([t0 T],[s0(3) S(3,:)]/deg)
hold on
plot([t0 t1],[180 180],':')
hold off
xlabel('Time (Seconds)')
ylabel('Truck Angle (Degrees)')
grid

figure(f5);
plot(T,U/deg)
hold on
plot([t0 t1],[0 0],':')
hold off
xlabel('Time (Seconds)')
ylabel('Steering Angle (Degrees)')
grid

set(info_str(1),'string','Completed with Truck Simulation!');

if strcmp(get(f1,'name'),'Controlled Truck: Controller 1'),
 set(info_str(2),'string','Try Controller 2...?');
 set(b(3),'string','Controller 2','callback','trkdemog');
else
 set(info_str(2),'string','Try Controller 1...?');
 set(b(3),'string','Controller 1','callback','trkdemod');
end
set(info_win,'vis','on');
