% Stage 3 for Truck Demonstration

% Copyright (c) 1993 by PWS Publishing Company

% FUZZY SETS
% ==========

set(info_win,'vis','off');
set(info_str,'string','');
if length(han),
 delete(han);
 han=[];
end

% HORIZONTAL POSITION: 5 Equally spaced triangles
hposS = 0:(100/24):100;
hposL = eqshape(3,hposS,5);
hposG = shapeval(hposL,hposS);

% TRUCK ANGLE: 7 Equally spaced triangles
deg = (pi/180);
angleS = [0:4:360]*deg;
angleL = eqshape(3,angleS,7); 
angleG = shapeval(angleL,angleS);

% STEERING ANGLE: 7 Equally spaced triangles
steeringS = [-30:1:30]*deg;
steeringL = eqshape(3,steeringS,7);
steeringG = shapeval(steeringL,steeringS);

% PLOT FUZZY SETS
% ===============
set([f1,f5],'vis','off');
delete(get(f2,'chil'));
delete(get(f3,'chil'));
delete(get(f4,'chil'));
set(f2,'name','Fuzzy Sets for Horizontal Position',...
       'pos',[167,250,305,205]./scrn);
set(f3,'name','Fuzzy Sets for Truck Angle',...
       'pos',[10,10,305,205]./scrn);
set(f4,'name','Fuzzy Sets for Steering Angle',...
       'pos',[325,10,305,205]./scrn);

figure(f2);
plotfs2(hposS,'Fuzzy Sets for Horizontal Position', ...
  'Horizontal Position in meters')
plot(hposS,hposG)

figure(f3);
plotfs2(angleS/deg,'Fuzzy Sets for Truck Angle', ...
  'Truck Angle in Degrees')
plot(angleS/deg,angleG)

figure(f4);
plotfs2(steeringS/deg,'Fuzzy Sets for Steering Angle', ...
  'Steering Angle in Degrees')
plot(steeringS/deg,steeringG)
drawnow;

% DEFINITION OF CONTROLLER
% ========================
% Decides steering angle based on truck horizontal position and angle:

% ANTECEDANT TABLE
A = table(1:5,1:7);

% CONSEQUENCE TABLE, Rows represent angle, Columns represent position
C = [5; 6; 6; 7; 7;
     3; 5; 6; 7; 7;
     3; 3; 6; 6; 7;
     2; 2; 4; 6; 6;
     1; 2; 2; 5; 5;
     1; 1; 2; 3; 3;
     1; 1; 2; 2; 3;];

% GROUP OF FUZZY SETS
Z = group(hposS,hposG,angleS,angleG,steeringS,steeringG);

left=(scrnsz(3)-300)/2;
botm=(scrnsz(4)-80)/2;
set(info_win,'pos',[left,botm,300,80]);
set(info_str(1),'string','View Truck Controller 1 in action...?',...
                'pos',[20,55,260,20]);
set(info_str(2),'pos',[20,30,260,20]);
set(b(1),'pos',[7,5,90,20]);
set(b(2),'vis','off','pos',[105,5,90,20]);
set(b(3),'string','Controller 1','callback','trkdemoe',...
         'pos',[203,5,90,20]);
set(info_win,'vis','on');


