% Stage 2 for Truck Demonstration

% Copyright (c) 1993 by PWS Publishing Company

% SIMULATION UNCONTROLLED TRUCK
% =============================

set(info_win,'vis','off');
set(info_str,'string','');
if length(han),
 delete(han);
 han=[];
end


% INITIAL STATE
deg = (pi/180);
s0 = [30; -70; 70*deg];

% Horizontal position = 30 meters
% Vertical position = -70 meters
% Truck angle = 70 degrees

% TIME
t0 = 0;
t1 = 160;
dt= 0.3;
T = (t0+dt):dt:t1;
steps = length(T);

% STEERING ANGLE
u = 2*deg;

S = zeros(3,steps);

s = s0;
trkplot(s,u,f1,1);
drawnow;

for i=1:steps

  % UPDATE STATE
  s = s + dt * trukmod(s,u);

  % MAKE SURE ANGLE BETWEEN 0 AND 2*PI
  s(3) = rem(s(3), 2*pi);

  % DRAW TRUCK EVERY 5 TIME STEPS
  if rem(i,5) == 0
    trkplot(s,u,f1,0);
  end

  % UPDATE RESPONSES
  S(:,i) = s;
 
end

left=(scrnsz(3)-300)/2;
botm=(scrnsz(4)-80)/2;
set(info_win,'pos',[left,botm,300,80]);
set(info_str(1),'string','View Responses...?','pos',[20,55,260,20]);
set(info_str(2),'pos',[20,30,260,20]);
set(b(1),'vis','on','pos',[7,5,90,20]);
set(b(2),'vis','off','pos',[105,5,90,20]);
set(b(3),'string','Responses','callback','trkdemoc',...
         'pos',[203,5,90,20],'vis','on');
set(info_win,'vis','on');


