function g=trapzoid(s,v)
% TRAPZOID Creates trapezoidal shaped fuzzy sets.
%
% TRAPZOID(S,[A1,B1,C1,D1; ...; An,Bn,Cn,Dn])
%   S  - Row vector of support values.
%   Ai - Threshold support value for ith grade vector.
%   Bi - Lower peak support value for ith grade vector.
%   Ci - Greater peak support value for ith grade vector.
%   Di - Cutoff support value for ith grade vector.
% Returns n grade vectors with values rising from
%   0 to 1 in the interval [Ai,Bi], staying at
%   1 in the interval [Bi,Ci], and returning
%   to 0 in the interval [Ci,Di].
%
% EXAMPLE: s = 0:.1:10;
%          g = trapzoid(s,[3,5,7,9]);
%          plotfs(s,'Trapezoidal Fuzzy Set')
%          plot(s,g)
%          hold off
%
% SEE ALSO: Bell, Bump, Flatbump, Rectangl, Rectangl, Single, Triangle

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

[vr,vc] = size(v);
g = zeros(vr,length(s));

for i=1:vr
  a = v(i,1);
  b = v(i,2);
  c = v(i,3);
  d = v(i,4);

  up = find(s>a & s<b);
  peak = find(s>=b & s<=c);
  down = find(s>c & s<d);

  if length(up), g(i,up) = (s(up)-a)/(b-a); end
  if length(peak), g(i,peak) = ones(1,length(peak)); end
  if length(down), g(i,down) = (d-s(down))/(d-c); end
end
