% Stage 5 for Pendulum Demonstration

% Copyright (c) 1993 by PWS Publishing Company

% PLOT RESPONSES
% ==============

set([f1,info_win],'vis','off');
set(info_str,'string','');

delete(get(f2,'chil'));
delete(get(f3,'chil'));
delete(get(f4,'chil'));
set(f2,'name','Position Response','pos',[167,250,305,205]./scrn);
set(f3,'name','Angular Response','pos',[10,10,305,205]./scrn);
set(f4,'name','Control Force Response','pos',[325,10,305,205]./scrn);

% POSITION RESPONSE
figure(f2);
plot([t0 T],[x0(1) X(1,:)])
hold on
plot([t0 t1],[0 0],':')
hold off
xlabel('Time (Seconds)')
ylabel('Position (Meters)')
grid

% ANGULAR RESPONSE
figure(f3);
plot([t0 T],[x0(3) X(3,:)]/deg)
hold on
plot([t0 t1],[0 0],':')
hold off
xlabel('Time (Seconds)')
ylabel('Angle (Degrees)')
grid

% FORCE RESPONSE
figure(f4);
plot(T,U)
hold on
plot([t0 t1],[0 0],':')
hold off
xlabel('Time (Seconds)')
ylabel('Force (Kg*m/s^2)')
grid

set(info_str(1),'string','Completed with Pendulum Simulation!');
set(b([1,3]),'vis','off');
set(b(2),'string','Done','callback',get(b(1),'callback'),'vis','on');
set(info_win,'vis','on');
