% PENDEMO Simulation of inverted pendulum.

% Copyright (c) 1993 by PWS Publishing Company

% setup beginning of demo
demostrt

set(info_win,'name','Inverted Pendulum');
set(b(2),'callback','pendemob');               
     
% PENDULUM WINDOW
f1 = figure('name','Uncontrolled Pendulum','numbertitle','off',...
            'units','norm','pos',[20,20,600,430]./scrn,'menubar','none',...
            'vis','off');

% POSITION RESPONSE WINDOW            
f2 = figure('name','Position Response','numbertitle','off',...
            'units','norm','pos',[10,10,305,200]./scrn,'menubar','none',...
            'vis','off');

% ANGULAR RESPONSE WINDOW            
f3 = figure('name','Angular Response','numbertitle','off',...
            'units','norm','pos',[325,10,305,200]./scrn,'menubar','none',...
            'vis','off');

% EXTRA WINDOWS FOR FUZZY SETS
f4 = figure('numbertitle','off',...
            'units','norm','pos',[117,129,315,230]./scrn,'menubar','none',...
            'vis','off');

f5 = figure('numbertitle','off',...
            'units','norm','pos',[169,88,315,230]./scrn,'menubar','none',...
            'vis','off');

f6 = figure('numbertitle','off',...
            'units','norm','pos',[226,45,315,230]./scrn,'menubar','none',...
            'vis','off');

f7 = figure('numbertitle','off',...
            'units','norm','pos',[278,3,315,230]./scrn,'menubar','none',...
            'vis','off');

windows=[info_win,f1,f2,f3,f4,f5,f6,f7];

str=['We would like to move a cart so that it balances an inverted pendulum and ',...
'completes the balancing at ''0'' on the horizontal scale.  The first screen shows an ',...
'uncontrolled pendulum simply falling onto the cart.'];

han=strformt(str,[80,480],info_win);
set(info_str(1),'string','Refer to Chapter 5 of the User''s Guide');
set(info_str(2),'string','Also, refer to the script PENDSIM');
set(info_win,'vis','on');
