function y=or(x1,x2,x3,x4,x5,x6,x7,x8,x9,x10)
% OR Fuzzy union (s-norm) using maximum.
%
% OR(G)
%   G - Matrix of grade (row) vectors.
% Returns a grade (row) vector.
%
% OR(G1,G2,G3,...)
%   Gi - Matrices or scalers.
% Returns a matrix.
%
% EXAMPLE: s = 1:.1:10;
%          g1 = large(s);
%          g2 = near(s,5);
%          g3 = or(g1,g2);
%          plotfs(s,'Fuzzy Set: Large OR Near 5')
%          plot(s,g1,':',s,g2,'--',s,g3);
%          hold off
%
% SEE ALSO: ora, orb, ory

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

% without this line, MATLAB 3.5k thinks that 'xi' is a file and quits
% with a 'Path not found' error
xi = [];

if nargin < 1
  error('Not enough arguments.')
end

if nargin == 1
  [xr,xc] = size(x1);
  if xr == 1
    y = x1;
  else
    y = max(x1);
  end
else
  y = x1;
  for i=2:nargin
    eval(sprintf('xi=x%g;',i));
    y = max(y,xi);
  end
end
