function y=fuzzyval(s,g,x)
% FUZZYVAL Fuzzy set evaluation.
%
% FUZZYVAL(S,G,X)
%   S - Row vector of support values.
%   G - Row vector(s) of associated grade values.
%   X - Particular support value(s).
% Returns grade(s) associated with support value(s).
%
% EXAMPLE: s = 0:.1:10;
%          g = [large(s); very(large(s))];
%          x = 7.2;
%          y = fuzzyval(s,g,x)
%
% SEE ALSO: shapeval

% Mark Beale 6-24-93
% Copyright (c) 1993 by PWS Publishing Company

if nargin < 3,error('Too few input arguments.'),end

[xr,xc] = size(x);
[gr,gc] = size(g);

if  gr ~= xr
  if (xr == 1)
    x = ones(gr,1)*x;
  else
    error('X and G have different number of rows in GETGRADE.')
  end
end

y = zeros(gr,xc);
for row = 1:gr
  for col = 1:xc
    support = x(row,col);
    index = find(s >= support);
    if (length(index) == 0)
      y(row,col) = g(row,gc);
    else
      index2 = index(1);
      if (index2 == 1)
        y(row,col) = g(row,1);
      else
        index1 = index2-1;
        s1 = s(index1);
        s2 = s(index2);
        g1 = g(row,index1);
        g2 = g(row,index2);
        y(row,col) = g1+(g2-g1)*(support-s1)/(s2-s1);
     end
    end
  end
end
