/*
 * penddraw.c	Drawing routines for the inverted pendulum demo.
 *
 * Copyright (c) Togai InfraLogic, Inc. 1989, 1990, 1991, 1992.
 * All rights reserved.
 *
 * $Header:   Z:/vcs/common/penddraw.c_v   1.0   13 Oct 1992 11:28:28   eah  $
 *
 * -------------------------------- Changes -----------------------------------
 * 10/13/92 eah (1) Split off from pendemo.c
 */

#include <graph.h>
#include <math.h>
#include <stdio.h>
#include <string.h>
#include <tilcomp.h>

#include "pendemo.h"

/*
 * for all rules, if the rule is disabled then if its DOM flag is on color
 * it light gray in the rule matrix, otherwise color it black.	If the
 * rule is enable then color it black.
 */

void drawActiveRules ()
{
    register int i;

#ifdef	FC110
    drawfc110mode (3);
#endif

    for (i = 0; i < numrules + 1; i++)

	if (!rulelist[i].disabled) {

	    if (rulelist[i].DOM)
		fillMatrixRule (3, i, LTGRAY);
	    else
		fillMatrixRule (3, i, BLACK);

	} else

	    fillMatrixRule (3, i, BLACK);
}

/*
 * update the timeline window in the upper left corner of the screen
 */

void updateTimeLine()
{
    char st[5];
    register int i;
    register int y;
    register int x;
    struct window w;

    w = windows[1];

    _setcolor (GRAY);
    _rectangle (_GFILLINTERIOR, w.horiz+14, w.vert+18, w.horiz+w.width-16, w.vert+80);
    _setcolor (LTBLUE);
    _rectangle (_GBORDER, w.horiz+14, w.vert+18, w.horiz+w.width-16, w.vert+80);

    _setcolor (BLACK);
    _moveto (w.horiz+15, w.vert+49);
    _lineto (w.horiz+w.width-17, w.vert+49);

    _setcolor (LTGRAY);
    _rectangle (_GFILLINTERIOR, w.horiz+21, w.vert+19, w.horiz+26, w.vert+79);
    _setcolor (LTBLUE);
    _rectangle (_GBORDER, w.horiz+21, w.vert+18, w.horiz+26, w.vert+80);

    _setcolor (BLACK);
    _moveto (w.horiz+22, w.vert+50+(int)(Current/3));
    _lineto (w.horiz+25, w.vert+50+(int)(Current/3));

    _setcolor (LTYELLOW);

    for (i = timelinemax; i > 0; i--) {
	if (i>1) {
	    x = w.horiz+27+(i*2);
	    y = w.vert+50+(int) (timelinedata[i-1]/3);
	    _moveto (x, y--);
	    _lineto (x, y++);
      }

      timelinedata[i] = timelinedata[i-1];
    }

    timelinedata[1] = Current;

    textcolor (WHITE);

    sprintf (st, "%4d", lastError);
    strat (12, 8, st);

    sprintf (st, "%4d", lastdError);
    strat (12, 19, st);

    sprintf (st, "%4d", Current);
    strat (13, 15, st);
}

/*
 * Open up a window on the screen on the currently active page.  This routine
 * accesses the information in the window array set in the initialization
 * portion of this program (Setwindow).  This routine is called twice in
 * succession to get the window image on both graphics pages. Also, if the
 * window is an mbf window (win=4 or 5), some other initialization is done
 * in Initmbfwin (win).
 */

void openwindow (win)
int win;
{
    int co;
    struct window w;

    w = windows[win];
    co = inactivewin;

    frame (win, co);
    _setcolor (w.interior);
    _rectangle (_GFILLINTERIOR, w.horiz, w.vert, w.horiz+w.width, w.vert+w.height);

    if (win == mbfwin)
	initmbfwin (win);

    if (win == currentwin)
	initcurrentwin (win);

    _setactivepage (!visualPage);
    _setcolor (w.interior);
    _rectangle (_GFILLINTERIOR, w.horiz, w.vert, w.horiz+w.width, w.vert+w.height);
    frame (win, co);

    if (win == mbfwin)
	initmbfwin (win);

    if (win == currentwin)
	initcurrentwin (win);

    _setactivepage (visualPage);
}


void initcurrentwin (win)
int win;
{
    struct window w;

    w=windows[win];

    if (win == helpwin) {
      w.width = windows[currentwin].width;
      w.height = windows[currentwin].height;
      w.vert = w.vert+50;
    }

    _setcolor (GRAY);
    _rectangle (_GFILLINTERIOR, w.horiz+20, w.vert+43, w.horiz+148, w.vert+107);
    _setcolor (BLUE);
    _rectangle (_GBORDER, w.horiz+19, w.vert+42, w.horiz+149, w.vert+108);
    _rectangle (_GBORDER, w.horiz+18, w.vert+41, w.horiz+150, w.vert+109);

    drawbar (Error, w.horiz+5, w.vert+15, 64, 10);
    drawbar (dError, w.horiz+w.width-69, w.vert+15, 64, 10);
    drawbar (Current, w.horiz+(w.width/2)-35, w.vert+w.height-16, 64, 10);

    _putimage (w.horiz+18, w.vert, miscmaps[0], _GPSET);
    _putimage (w.horiz+115, w.vert, miscmaps[1], _GPSET);
    _putimage (w.horiz+55, w.vert+w.height-31, miscmaps[7], _GPSET);

    _setcolor (LTYELLOW);
    _moveto (w.horiz+37, w.vert+28);
    _lineto (w.horiz+37, w.vert+33);
    _lineto (w.horiz+84, w.vert+33);
    _lineto (w.horiz+84, w.vert+40);

    _lineto (w.horiz+81, w.vert+37);
    _moveto (w.horiz+84, w.vert+40);
    _lineto (w.horiz+87, w.vert+37);

    _moveto (w.horiz+w.width-69+32, w.vert+28);
    _lineto (w.horiz+w.width-69+32, w.vert+33);
    _lineto (w.horiz+84, w.vert+33);

    _moveto (w.horiz-3+(w.width/2), w.vert+110);
    _lineto (w.horiz-3+(w.width/2), w.vert+w.height-29);
    _lineto (w.horiz-3+(w.width/2)-3, w.vert+w.height-32);
    _moveto (w.horiz-3+(w.width/2), w.vert+w.height-29);
    _lineto (w.horiz-3+(w.width/2)+3, w.vert+w.height-32);
}


/*
 * If a new window has been opened up, and it is an mbf window, we need to/
 * draw some static information to the screen.	This info. will never change
 * while the window is open, so we only do it once.
 */

void initmbfwin (win)
int win;
{
    int i;
    int col;
    struct window w;

    col = 44;
    w = windows[win];

    _putimage (w.horiz+160, w.vert+7, miscmaps[0], _GPSET);
    _putimage (w.horiz+160, w.vert+77, miscmaps[1], _GPSET);
    _putimage (w.horiz+310, w.vert+34, miscmaps[7], _GPSET);
    _putimage (w.horiz+10, w.vert, rulemaps[0], _GPSET);

    _setcolor (LTBLUE);
    _rectangle (_GFILLINTERIOR,w.horiz+133,w.vert,w.horiz+135,w.vert+w.height);
    _moveto (w.horiz, w.vert+13);
    _lineto (w.horiz+133, w.vert+13);
    _moveto (w.horiz+125, w.vert+13);
    _lineto (w.horiz+125, w.vert+w.height);

    for (i = 1; i < 12; i++)
	_putimage (w.horiz+10, w.vert+(i*12)+2, rulemaps[i], _GOR);	/* was GPSET */

    w.horiz = w.horiz+40;
    _putimage (w.horiz+225, w.vert+69, minstrmap, _GPSET);

    _setcolor(GRAY);
    _rectangle(_GFILLINTERIOR,w.horiz+120,w.vert+22,w.horiz+205,w.vert+22+43);
    _rectangle(_GFILLINTERIOR,w.horiz+120,w.vert+92,w.horiz+205,w.vert+92+43);
    _rectangle(_GFILLINTERIOR,w.horiz+270,w.vert+50,w.horiz+355,w.vert+50+43);

    _setcolor(BLUE);
    _rectangle(_GBORDER,w.horiz+119,w.vert+22,w.horiz+206,w.vert+24+43);
    _rectangle(_GBORDER,w.horiz+118,w.vert+21,w.horiz+207,w.vert+25+43);

    _rectangle(_GBORDER,w.horiz+119,w.vert+92,w.horiz+206,w.vert+94+43);
    _rectangle(_GBORDER,w.horiz+118,w.vert+91,w.horiz+207,w.vert+95+43);

    _rectangle(_GBORDER,w.horiz+269,w.vert+49,w.horiz+356,w.vert+51+43);
    _rectangle(_GBORDER,w.horiz+268,w.vert+48,w.horiz+357,w.vert+52+43);

    _setcolor (LTYELLOW);
    _moveto (w.horiz+208, w.vert+20+22);
    _lineto (w.horiz+235, w.vert+20+22);
    _lineto (w.horiz+235, w.vert+20+47);
    _lineto (w.horiz+231, w.vert+20+43);
    _lineto (w.horiz+235, w.vert+20+47);
    _lineto (w.horiz+239, w.vert+20+43);

    _moveto (w.horiz+208, w.vert+80+32);
    _lineto (w.horiz+235, w.vert+80+32);
    _lineto (w.horiz+235, w.vert+80+6);
    _lineto (w.horiz+231, w.vert+80+10);
    _lineto (w.horiz+235, w.vert+80+6);
    _lineto (w.horiz+239, w.vert+80+10);

    _moveto (w.horiz+254, w.vert+75);
    _lineto (w.horiz+267, w.vert+75);
    _lineto (w.horiz+263, w.vert+71);
    _lineto (w.horiz+267, w.vert+75);
    _lineto (w.horiz+263, w.vert+79);
    _setcolor (GREEN);
}

/*
 * draw the inverted pendulum in window win at Theta degrees
 */

void drawpendulum (win, Theta)
int win;
double Theta;
{
    int hw;
    int centerBobX;
    int centerBobY;
    struct window w;

    w = windows[win];
    hw = w.horiz + (w.width / 2);
    paintinterior (win);

    _putimage (w.horiz+75, w.vert+86, miscmaps[10], _GPSET);
    _setcolor (GRAY);
    _rectangle (_GFILLINTERIOR, w.horiz+45, w.vert+95, w.horiz+55, w.vert+99);
    _setcolor (LTBLUE);
    _rectangle (_GBORDER, w.horiz+45, w.vert+95, w.horiz+55, w.vert+99);

    if (!allowbopping)
	_setcolor (RED);
    else
	_setcolor (BLACK);

    _ellipse(_GFILLINTERIOR, w.horiz+59, w.vert+95, w.horiz+63, w.vert+99);
    _setcolor (pendstick);
    _moveto (w.horiz+118, w.vert+95);
    _lineto (w.horiz+120, w.vert+93);
    _lineto (w.horiz+122, w.vert+95);
    _moveto (w.horiz+120, w.vert+93);
    _lineto (w.horiz+120, w.vert+100);
    _lineto (w.horiz+118, w.vert+98);
    _lineto (w.horiz+120, w.vert+100);
    _lineto (w.horiz+122, w.vert+98);

    if (stickstop)
	_setcolor (RED);
    else
	_setcolor (BLACK);

    _ellipse (_GFILLINTERIOR, w.horiz+126, w.vert+95, w.horiz+130, w.vert+99);

    _setcolor (LTBLUE);
    _moveto (w.horiz,w.vert+102);
    _lineto (w.horiz+w.width, w.vert+102);

/* Draw pendulum shaft */

    centerBobX = w.horiz + (int) (90.0 + ((35.0+sticksize*2) * cos(Theta)));
    centerBobY = w.vert + (int) (80.0 - ((25.0+sticksize*2) * sin(Theta)));

    _setcolor (pendstick);
    _moveto (centerBobX, centerBobY);
    _lineto (w.horiz+90, w.vert+85);

/* Draw pendulum motor */

    _setcolor (pendmotor);
    _ellipse (_GFILLINTERIOR, w.horiz+90-(motorsize/6)-1, w.vert+85-(motorsize/6)-1,
			      w.horiz+90+(motorsize/6)+1, w.vert+85+(motorsize/6)+1);

    _setcolor (LTYELLOW);
    _ellipse (_GBORDER, w.horiz+90-(motorsize/6)-1, w.vert+85-(motorsize/6)-1,
			w.horiz+90+(motorsize/6)+1, w.vert+85+(motorsize/6)+1);

/* Draw pendulum bob */

    _setcolor (pendball);
    _ellipse (_GFILLINTERIOR, centerBobX-(bobmass/2), centerBobY-(bobmass/2),
			      centerBobX+(bobmass/2), centerBobY+(bobmass/2));

    _setcolor(LTYELLOW);
    _ellipse(_GBORDER, centerBobX-(bobmass/2), centerBobY-(bobmass/2),
	     centerBobX+(bobmass/2), centerBobY+(bobmass/2));

/* Draw bob and motor size bar graphs */

    _setcolor (pendball);
    _ellipse (_GFILLINTERIOR, w.horiz+5, w.vert+107, w.horiz+11, w.vert+113);
    _setcolor (pendmotor);
    _ellipse (_GFILLINTERIOR, w.horiz+5, w.vert+124, w.horiz+11, w.vert+130);

    _setcolor (WHITE);
    _moveto (w.horiz+15, w.vert+110);
    _lineto (w.horiz+15, w.vert+113);
    _lineto (w.horiz+w.width-10, w.vert+113);
    _lineto (w.horiz+w.width-10, w.vert+110);
    _moveto (w.horiz+15, w.vert+124);
    _lineto (w.horiz+15, w.vert+127);
    _lineto (w.horiz+w.width-10, w.vert+127);
    _lineto (w.horiz+w.width-10, w.vert+124);

    showscaledvar (bobmass, bobmin, bobsteps, w.horiz+15, w.horiz+w.width-10,w.vert+109, pendball);
    showscaledvar (motorsize, motormin, motorsteps, w.horiz+15, w.horiz+w.width-10, w.vert+123, pendmotor);

    pendball = nobumpball;

/* Do bopper animation */

    if (animatebop && allowbopping) {

	if (extendbopper < centerBobX-w.horiz-12 || (retractbopper && extendbopper > 0)) {
	    _setcolor(GRAY);

	    if (!retractbopper)
		bopperimpactpt = centerBobY;

	    if (!retractbopper) {
		_rectangle (_GFILLINTERIOR, w.horiz, centerBobY, w.horiz+extendbopper, centerBobY+5);
		_setcolor (LTBLUE);
		_rectangle (_GBORDER, w.horiz, centerBobY, w.horiz+extendbopper, centerBobY+5);
	    } else {
		_rectangle (_GFILLINTERIOR, w.horiz, bopperimpactpt, w.horiz+extendbopper, bopperimpactpt+5);
		_setcolor (LTBLUE);
		_rectangle (_GBORDER, w.horiz, bopperimpactpt, w.horiz+extendbopper, bopperimpactpt+5);
	    }

	    if (retractbopper) {
		extendbopper = extendbopper - 8;

		if (extendbopper == 0) {
		    retractbopper = FALSE;
		    animatebop = FALSE;
		}
	    } else
		extendbopper = extendbopper + 8;

	} else {
	    Omega = (float) Omega - 10;
	    pendball = bumpball;
	    retractbopper = TRUE;
	}
    }
}

/*
 * draw the value for current in win
 */

void  drawcurrent (win)
int win;
{
    register int i;
    struct window w;

    w = windows[win];

    if (win == helpwin) {
	w.width = windows[currentwin].width;
	w.height = windows[currentwin].height;
	w.vert = w.vert+50;
    }

    _setcolor (GRAY);
    _rectangle (_GFILLINTERIOR, w.horiz+20, w.vert+43, w.horiz+148, w.vert+107);
    drawbar (Error, w.horiz+5, w.vert+15, 64, 10);
    drawbar (dError, w.horiz+w.width-69, w.vert+15, 64, 10);
    drawbar (Current, w.horiz+(w.width/2)-35, w.vert+w.height-15, 64, 10);
    _setcolor (RED);

    for (i = 0; i < numrules+1; i++)
	if (rulelist[i].DOM)
	    drawbigmembval (w.horiz+20, w.vert+43, rulelist[i].DOM, rulelist[i].currentptr);

    _setcolor (LTYELLOW);
    _moveto (w.horiz+20+(int)((Current+128)/2), w.vert+43);
    _lineto (w.horiz+20+(int)((Current+128)/2), w.vert+43+64);
}

void showscaledvar (var, mini, steps ,start, end, vert, col)
int var;
int mini;
int steps;
int start;
int end;
int vert;
int col;
{
    int th;

    th = (var-mini) * ((end-start)/steps);
    _setcolor (col);
    _moveto (start+th, vert+3);
    _lineto (start+th-3, vert);
    _lineto (start+th+3, vert);
    _lineto (start+th, vert+3);
}

void drawbigmembval (x, y, input, current)
int x;
int y;
int input;
int current;
{
    register int i;
    register int loop;

    for (loop = 0; loop < 128; loop++) {
	i = s4data[current][loop*2];

	if (i > (int) (input / 4))
	       i = (int) (input / 4);

	if (i > 1) {
	    _moveto (x+loop, y+64);
	    _lineto (x+loop, y+64-i);
	}
    }
}

void drawrule ()
{
    struct window w;

    w = windows[mbfwin];

    if (ruletodisable != -1) {

	if (rulelist[currule].disabled)
	    _setcolor (RED);
	else
	    _setcolor (BLACK);

	_ellipse (_GFILLINTERIOR, w.horiz+127, w.vert+17+(currule*12),
				  w.horiz+131, w.vert+21+(currule*12));
    }

    if (currule != oldrule) {

       /* Highlight new rule */

	_setcolor (LTGRAY);
#ifdef	NEC_PC
	_rectangle (_GFILLINTERIOR, w.horiz, w.vert+(currule*12)+16, w.horiz+124,w.vert+(currule*12)+27);
#else
	_rectangle (_GFILLINTERIOR, w.horiz, w.vert+(currule*12)+14, w.horiz+124,w.vert+(currule*12)+26);
#endif

	_putimage (w.horiz+10, w.vert+(currule*12)+14, rulemaps[currule+1], _GXOR);

	/* Unhighlight old rule */

	_setcolor (BLACK);
#ifdef	NEC_PC
	_rectangle (_GFILLINTERIOR, w.horiz,w.vert+(oldrule*12)+16, w.horiz+124,w.vert+(oldrule*12)+27);
#else
	_rectangle (_GFILLINTERIOR, w.horiz,w.vert+(oldrule*12)+14, w.horiz+124,w.vert+(oldrule*12)+26);
#endif

	_putimage (w.horiz+10, w.vert+(oldrule*12)+14,rulemaps[oldrule+1], _GOR);  /* was GPSET */

	_putimage (w.horiz+230, w.vert+7, miscmaps[rulelist[currule].thetaptr+2], _GPSET);
	_putimage (w.horiz+230, w.vert+77, miscmaps[rulelist[currule].dthetaptr+2], _GPSET);
	_putimage (w.horiz+379, w.vert+33, miscmaps[rulelist[currule].currentptr+2], _GPSET);
    }

    drawmbf (w.horiz+160, w.vert+23, 0, Error, rulelist[currule].thetaptr);
    drawmbf (w.horiz+160, w.vert+93, 1, dError, rulelist[currule].dthetaptr);
    drawdom (w.horiz+310, w.vert+50, rulelist[currule].currentptr);
}

void drawmbf (horiz, vert, list, terror, mbfptr)
int horiz;
int vert;
int list;
int terror;
int mbfptr;
{
    int i;
    int j;
    int st;
    int ed;
    register int ld;
    register int loop;

    _setcolor (GRAY);
    _rectangle (_GFILLINTERIOR, horiz, vert, horiz+85, vert+43);

    st = rulelist[currule].pointlists[list][0].vv;
    ed = rulelist[currule].pointlists[list][0].bv;

    for (loop=st;loop<ed+1;loop=loop+3) {
	i = s6data[mbfptr][loop];
	j = i;
	ld = (int) (loop / 3);
	_setcolor (RED);

	if (i > s6data[mbfptr][terror+128])
	    i=s6data[mbfptr][terror+128];

	_moveto (horiz+ld, vert+42);
	_lineto (horiz+ld, vert+42-i);
	_setcolor(LTGRAY);

	if (j - i > 2)
	    _lineto (horiz+ld, vert+42-j);
    }

    _setcolor (BLACK);
    _moveto (horiz+43, vert);
    _lineto (horiz+43, vert+43);

    _setcolor (LTYELLOW);
    _moveto (horiz+42+terror/3, vert);
    _lineto (horiz+42+terror/3, vert+43);

    _moveto (horiz, vert+43-s6data[mbfptr][terror+128]);
    _lineto (horiz+85, vert+43-s6data[mbfptr][terror+128]);
}

void drawdom (horiz, vert, mbfptr)
int horiz;
int vert;
int mbfptr;
{
    int i;
    int j;
    int st;
    int ed;
    int ld3;
    int td6;
    UBYTE terror;
    register int loop;

    terror = (UBYTE) (rulelist[currule].DOM);
    td6= (int) (terror / 6);

    _setcolor (GRAY);
    _rectangle (_GFILLINTERIOR, horiz, vert, horiz+85, vert+43);

    st = rulelist[currule].pointlists[2][0].vv;
    ed = rulelist[currule].pointlists[2][0].bv;

    for (loop = st; loop < ed+1; loop = loop + 3) {
	i = (int) (s6data[mbfptr][loop]);

	j = i;
	ld3 = (int) loop / 3;
	_setcolor (RED);

	if (i > td6)
	    i = td6;

	_moveto(horiz+ld3,vert+43);
	_lineto(horiz+ld3,vert+43-i);
	_setcolor(LTGRAY);

	if (j - i > 2)
	    _lineto (horiz+ld3, vert+43-j);
    }

    _setcolor (BLACK);
    _moveto (horiz+42, vert);
    _lineto (horiz+42, vert+43);

    _setcolor (LTYELLOW);
    _moveto (horiz, vert+43-td6);
    _lineto (horiz+85, vert+43-td6);

}

/*
 *  After user has arrowed to a new position in the mbf rule matrix, update
 *  the screen to show them where they are
 */

void updatecurmbf (dirx, diry)
int dirx, diry;
{
    int newy;
    int newx;
    int ole;
    int nle;

    newx = curmbfx;
    newy = curmbfy;

    newx = newx + dirx;

    if (newx > 4)
	newx = 0;

    if (newx < 0)
	newx = 4;

    newy = newy + diry;

    if (newy > 4)
	newy = 0;

    if (newy < 0)
	newy = 4;

    nle = findelem (newx, newy);
    ole = findelem (curmbfx, curmbfy);
}


void drawtimeline(win)
int win;
{
    struct window w;

    w = windows[win];
    paintinterior (win);
    _setcolor (LTBLUE);
    _moveto (w.horiz, w.vert+94);
    _lineto (w.horiz+w.width, w.vert+94);

    _putimage (w.horiz+58, w.vert+4, miscmaps[7], _GPSET);

    _putimage (w.horiz+6, w.vert+98, miscmaps[0], _GPSET);
    _putimage (w.horiz+87, w.vert+98, miscmaps[1], _GPSET);

    _putimage (w.horiz+44, w.vert+112, miscmaps[7], _GPSET);
}

#ifdef	FC110

void drawfc110mode (win)
int win;
{
    struct window w;

    w = windows[win];

    _putimage (w.horiz+13, w.vert+10, miscmaps[fc110 ? 12 : 11], _GPSET);
}

#endif

/*
 *  Initialize the mbf rule matrix window interior information
 */

void drawRuleMatrix (win)
int win;
{
    register int i;
    struct window w;

    w = windows[win];
    paintinterior (win);
    textcolor (LTYELLOW);

#ifdef	FC110
    drawfc110mode (win);
#endif

    _putimage (w.horiz+93, w.vert+10, miscmaps[0], _GPSET);
    sideways (7, 57, "dTheta");

    textcolor (WHITE);
    strat (7, 63, "NM NS Z  PS PM");
    sideways (8, 60, "NN PP");
    sideways (8, 61, "MSZSM");

    _setcolor (LTBLUE);

    for (i = 0; i < 6; i++) {
	_moveto (w.horiz+57, (i*14)+w.vert+41);
	_lineto (w.horiz+177, (i*14)+w.vert+41);
	_moveto (w.horiz+57+(i*24), w.vert+41);
	_lineto (w.horiz+57+(i*24), w.vert+111);
    }
}

/*
 *  Fill a given x,y in the rule matrix with a color to designate its state
 */

void fillMatrixRule (win,rule,col)
int win,rule,col;
{
    int x;
    int y;
    struct window w;

    w = windows[win];
    x = w.horiz + 58 + ((4 - rulelist[rule].thetaptr) * 24);
    y = w.vert + 42 + ((4 - rulelist[rule].dthetaptr) * 14);
    _setcolor (col);
    _rectangle (_GFILLINTERIOR, x, y, x+22, y+12);

    if (!rulelist[rule].disabled)
#ifdef	NEC_PC
	_putimage (x+4, y - 1, miscmaps[rulelist[rule].currentptr+2], _GXOR);
#else
	_putimage (x+4, y, miscmaps[rulelist[rule].currentptr+2], _GXOR);
#endif
}

/*
 * Create a bitmap for the title information so we can place it anywhere we
 * want without being constrained by the text drawing routines
 */

void createbitmaps ()
{
    textcolor (LTYELLOW);

    miscmaps[0] = string_bitmap ("Theta");
    miscmaps[1] = string_bitmap ("dTheta");

    textcolor (GREEN);

    miscmaps[2] = string_bitmap ("PM");
    miscmaps[3] = string_bitmap ("PS");
    miscmaps[4] = string_bitmap ("Z ");
    miscmaps[5] = string_bitmap ("NS");
    miscmaps[6] = string_bitmap ("NM");

    textcolor (LTYELLOW);

    miscmaps[7] = string_bitmap ("Current");

#ifdef	FC110
    miscmaps[11] = string_bitmap ("Fuzzy-C");
    miscmaps[12] = string_bitmap ("FC110  ");
#endif

    miscmaps[9] = new_bitmap (0, 0, 10, 66);
    _setcolor (GRAY);
    _rectangle (_GFILLINTERIOR, 0, 6, 10, 64);
    _setcolor (BLACK);
    _moveto (0, 35);
    _lineto (10, 35);
    _setcolor (GREEN);
    _moveto (5, 0);
    _lineto (0, 5);
    _lineto (5, 5);
    _lineto (9, 0);
    _lineto (5, 0);
    _setcolor (WHITE);
    _floodfill (5, 4, GREEN);
    _setcolor (GREEN);
    _moveto (5, 60);
    _lineto (0, 65);
    _lineto (5, 65);
    _lineto (9, 60);
    _lineto (5, 60);
    _setcolor (WHITE);
    _floodfill (5, 64, GREEN);
    _setcolor (WHITE);
    _rectangle (_GFILLINTERIOR, 5, 0, 9, 60);
    _setcolor (GREEN);
    _rectangle (_GBORDER, 5, 0, 9, 60);
    _getimage (0, 0, 10, 66, miscmaps[9]);

    miscmaps[10] = new_bitmap (0, 0, 30, 15);
    _setcolor (BLACK);
    _rectangle (_GFILLINTERIOR, 0, 0, 30, 30);
    _setcolor (pendframe);
    _moveto (15, 0);
    _lineto (0, 15);
    _lineto (30, 15);
    _lineto (15, 0);
    _setcolor (pendbase);
    _floodfill (15, 10, pendframe);
    _getimage (0, 0, 30, 15, miscmaps[10]);

    textcolor (LTYELLOW);

    rulemaps[0] = string_bitmap ("Theta   dTheta");

    textcolor (WHITE);

    rulemaps[1] = string_bitmap ("  Z   &   Z ");
    rulemaps[2] = string_bitmap ("  Z   &   NM");
    rulemaps[3] = string_bitmap ("  Z   &   NS");
    rulemaps[4] = string_bitmap ("  Z   &   PS");
    rulemaps[5] = string_bitmap ("  Z   &   PM");
    rulemaps[6] = string_bitmap (" NM   &   Z ");
    rulemaps[7] = string_bitmap (" NS   &   Z ");
    rulemaps[8] = string_bitmap (" PS   &   Z ");
    rulemaps[9] = string_bitmap (" PM   &   Z ");
    rulemaps[10] = string_bitmap (" PS   &   NS");
    rulemaps[11] = string_bitmap (" NS   &   PS");

    _setcolor (BLACK);
    _rectangle (_GFILLINTERIOR, 0, 0, 130, 137);

    textcolor (WHITE);

    minstrmap = string_bitmap ("min");
    titlebarmap[0] = new_bitmap (139, 0, 500, CHAR_HEIGHT - 1);
    strat (1, 40-strlen(title1)/2, title1);
    _getimage (139, 0, 500, CHAR_HEIGHT - 1, titlebarmap[0]);

    titlebarmap[1] = new_bitmap (139, 0, 500, CHAR_HEIGHT - 1);
    strat (1, 40-strlen (title2)/2, title2);
    _getimage (139, 0, 500, CHAR_HEIGHT - 1, titlebarmap[1]);

    titlebarmap[2] = new_bitmap (139, 0, 500, CHAR_HEIGHT - 1);
    strat (1, 40-strlen(title3)/2, title3);
    _getimage (139, 0, 500, CHAR_HEIGHT - 1, titlebarmap[2]);
}

/*
 *  Draw the heading window information...
 */

void animateheading ()
{
    struct window w;

    w = windows[titlewin];

    paintinterior (titlewin);
    frame (titlewin, inactivewin);
    swapvideopages ();

    paintinterior (titlewin);
    frame (titlewin, inactivewin);
    swapvideopages ();

    _putimage (139, 5,	titlebarmap[0], _GOR);
    _putimage (139, 19, titlebarmap[1], _GOR);
    _putimage (139, 33, titlebarmap[2], _GOR);
    swapvideopages ();

    _putimage (139, 5,	titlebarmap[0], _GOR);
    _putimage (139, 19, titlebarmap[1], _GOR);
    _putimage (139, 33, titlebarmap[2], _GOR);
    swapvideopages ();
}
