/*
 * Copyright (c) 1992 The University of Utah and
 * the Center for Software Science (CSS).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 *      Utah $Hdr$
 *      Author: Doug Orr, University of Utah CSS
 */

#ifndef	_gen_h_
#define	_gen_h_	1

#include <string.h>
#include <stdlib.h>

#ifdef unix
#   include <unistd.h>
#   if defined(__GNUG__) && defined(HPOSF)
#       include <osfcn.h>
#   endif
#   if defined(__GNUC__) && defined(__hpux)
	extern "C" void * __builtin_saveregs();
#   endif
#endif


/* Generic routines and definitions. */

template<class A> int 	Count(A a)			{ return (sizeof (a) / sizeof a[0]); }
template<class A> int	In(int idx, A a)		{ return idx >= 0 && idx < Count(a); }
template<class A> A * 	ReNewArray(A * a, int siz)	{ return (A *)(realloc ((char *)a, sizeof (*a)*count)); }

template<class T> T 	Max(T x, T y)			{ return ((x) > (y) ? (x) : (y)); }
template<class T> T 	Min(T x, T y)			{ return ((x) < (y) ? (x) : (y)); }

#if	defined(DEBUG) && !defined(NO_ASSERT)
#define	Assert(cond)							\
	if (!(cond)) {							\
		error ("%s:%d assertion failed\n", __FILE__, __LINE__); \
		exit (1);						\
	}
#else
#define	Assert(cond)
#endif

inline char * 
NewStr (const char *str)
{
	if ( str )
		return strcpy (new char [strlen (str) + 1], str);
	else
		return NULL;
}

inline int 
Abs (int x)
{
	return x < 0 ? -x : x;
}


enum bool_t
{
	false = 0,
	true = 1,
};

#endif	/* gen_h */
