/*
 * Copyright (c) 1992 The University of Utah and
 * the Center for Software Science (CSS).  All rights reserved.
 *
 * Permission to use, copy, modify and distribute this software is hereby
 * granted provided that (1) source code retains these copyright, permission,
 * and disclaimer notices, and (2) redistributions including binaries
 * reproduce the notices in supporting documentation, and (3) all advertising
 * materials mentioning features or use of this software display the following
 * acknowledgement: ``This product includes software developed by the Center
 * for Software Science at the University of Utah.''
 *
 * THE UNIVERSITY OF UTAH AND CSS ALLOW FREE USE OF THIS SOFTWARE IN ITS "AS
 * IS" CONDITION.  THE UNIVERSITY OF UTAH AND CSS DISCLAIM ANY LIABILITY OF
 * ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * CSS requests users of this software to return to css-dist@cs.utah.edu any
 * improvements that they make and grant CSS redistribution rights.
 *
 *      Utah $Hdr$
 *      Author: Doug Orr, University of Utah CSS
 */

/* fuzzy:  variables known to hold simple fuzzy values.

   the type of the fuzzy variable is specified as part of the
   class template (e.g., fuzzy<float> temperature (98.6);)

   fuzzy variables get optional names used for debugging purposes.

   */


#ifndef	_fuzzy_h_
#define	_fuzzy_h_ 1

#include <iostream.h>
#include "gen.h"
#include "degree.h"
#include "member.h"

template <class C> class fuzzy {
	char * n;
    protected:
	C v;			// current value
    public:
	fuzzy (C v_ = 0, char * n_ = NULL) : v(v_), n(NewStr(n_))		{}
	
				operator C () const;
	C &			operator = (const C & v_);

	degree 			is (const member<C> &) const;
	char *			name () const				{ return n ? n : "?"; }
};


/*  allow extracting the fuzzy value through
    casting or its use in some clear context */
template<class C>
fuzzy<C>::operator C () const
{
	return v;
}

/*  allow direct assignment to the fuzzy value  */
template<class C>
C &  fuzzy<C>::operator = (const C & v_)
{
	v = v_;
	return v;
}


/* is:  query the membership of a fuzzy value using
   a given membership function.  */
   
template<class C>
degree fuzzy<C>::is (const member<C> & m) const
{
	return m.is (v);
}

	
#endif	/* _fuzzy_h_ */
