/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/



#ifndef nfc_ed_h
#define nfc_ed_h

#include <InterViews/window.h>
#include <InterViews/glyph.h>

#include "wissensbank.h"
#include "lingvar_ed.h"
#include "regel_ed.h"
#include "anwend_ed.h"
#include "protokoll_ed.h"
#include "control_ed.h"

class DateiArbeit;
class Copyright;

struct FensterStrukt;

class NfcEditor : public MonoGlyph
{
  public : NfcEditor();
           ~NfcEditor();
           virtual void allocate(Canvas*, const Allocation&, Extension&);
           virtual void pick(Canvas*, const Allocation&, int, Hit&);

           void mach_lv_ed();
           void lv_ed_ende();
           void lv_ed_abbr();

           void mach_rg_ed();
           void rg_ed_ende();
           void rg_ed_abbr();

           void mach_an_ed();
           void an_ed_ende();
           void an_ed_abbr();

           void mach_pt_ed();
           void pt_ed_ende();
           void pt_ed_abbr();

           void mach_ct_ed();
           void ct_ed_ende();

  // lokale Funktionen
  private: void _init(FensterStrukt*);
           void _lv_fenster(boolean auf, boolean steuer_var);
           void _rg_fenster(boolean auf, boolean steuer_regeln);
           void _an_fenster(boolean auf);
           void _pt_fenster(boolean auf);
           void _ct_fenster(boolean auf);
           Menu* _mach_menue();
           void _datei();
           void _prg_ende();
           Glyph* _button_paar(Glyph* bt1, Glyph* bt2, char* text);

  // lokale Variablen
  private: int _auswahl, _menue_auswahl, _unter_menue_auswahl;
           Wissensbank* _wissensbank;
           boolean copyright_angezeigt;

  // Grafikelemente
  private: Window* _nfc_fenster;
           NfcAusgabe* _ausgabe_feld;
           DateiArbeit* _datei_arbeit;
           LingVarEd* _lv_editor;
           RegelEd* _rg_editor;
           ControllerEd* _controll_ed;
           ProtokollEd* _prot_ed;
           AnwendungsEd* _an_editor;
           ProtokollStruktur _protokoll_strukt;
};

#endif
