/* PENDULUM: a graphical simulation of an inverted pendulum; part of 
   NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 *   Grafik-Modul fuer die Pendelsimulation ( header-datei )
 */

#ifndef pendel_h
#define pendel_h

#include <Dispatch/iocallback.h>
#include <InterViews/monoglyph.h>
#include <InterViews/input.h>
#include <InterViews/patch.h>
#include "pendel_look.h"
#include "runge.h"

/*
 *------------------ Deklaration der Klasse : PendelFenster -------------------
 */

class PendelGrafik;

class PendelFenster : public InputHandler
{
  public : PendelFenster(Style*);
           ~PendelFenster();

  // lokale Funktionen
  private: int _lies_steuer_wert(int);
           void _schreib_messwerte();

           void _setz_winkel();
           void _setz_wi_geschw();
           void _setz_position();
           void _setz_wa_geschw();

           void _setz_strecke();
           void _setz_auto_start();
           void _setz_rnd_winkel();
           void _setz_sync();

           void _zufaelliger_winkel();
           void _zufaellige_geschw();

           void _start();
           void _stop();
           void _ende();

           void _zaehler_reset();

  // Zustandsvariablen
  private: PendelSim* _pend_sim;
           boolean _aktiv;
           int _zaehler;
           boolean _winkel_ausgeben, _wi_geschw_ausgeben,
                   _position_ausgeben, _wa_geschw_ausgeben,
                   _strecke_begrenzt;
           float _laenge_strecke;
           float _alte_pos;
           boolean _auto_start,
                   _rnd_winkel;
           int _sync_faktor;
           boolean _toggle1, _toggle2;
           int _anzahl_zyklen;
           char _buffer[50];         // Hilfsbuffer

  // Grafikelemente
  private: PendelGrafik* _pendel;
           Patch* _grafik;
           EingabeFeld *_winkel_ed, *_wi_geschw_ed,
                       *_position_ed, *_wa_geschw_ed,
                       *_strecke_ed, *_sync_ed;
           NfcAusgabe* _ausgabefeld;
           NfcLabel* _zaehler_feld;
};

#endif
