/* NEFCON-I: an interactive system for realization of a neural fuzzy controller

   Copyright (C) 1994 

   Institut fuer Betriebssysteme und Rechnerverbund, Technische Universitaet
   Braunschweig, Bueltenweg 74/75, 38106 Braunschweig, Germany, 
   hereby disclaims all copyright interests in the program NEFCON-I 
   written by Hermann-Josef Diekgerdes and Roland Stellmach.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 1, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/




#ifndef nfc_global_h
#define nfc_global_h

#include <OS/string.h>
#include <OS/list.h>

#define Min(a,b) ((a)<(b)?(a):(b))
#define Max(a,b) ((a)>(b)?(a):(b))
#define Abs(a)   ((a)>(0)?(a):(-1*(a)))
#define Sgn(a)   ((a)<(0)?(0):(1))

declareList(StringList,CopyString);

extern float rnd();

extern void hol_str(float zahl, char* str);
extern void hol_str(float zahl, char* str, int& anzahl);

extern void tausch(float& a, float& b);

enum AusgabeTyp { Fehler, Warnung, Meldung, Info };

/*
 *------------------------------------------------------------------------------
 * Klasse : Ausgabe
 * Zweck  : Deklariert die Funktionen zur Ausgabe von Fehlermeldungen.
 *------------------------------------------------------------------------------
 */
class Ausgabe
{
  public : virtual void ausgeben(AusgabeTyp, String) = 0;
           virtual void ausgeben(AusgabeTyp, String, String) = 0;
           virtual void ausgeben(AusgabeTyp, String, String, String) = 0;
};

#endif
