function u=unfuzzy2(Rs,SD,Aj)

%UNFUZZY2 is used for defuzzyfication
%
%         u=unfuzzy2(Rs,SD,Aj) starts another method for defuzzification.
%         Matrices Rs and Sd are a result of the PREPARE-function.
%         Matrix Aj contains the aggregated compatibility-factors of each
%         rule.
%         u is a vector containing the 'sharp' outputs of the fuzzy-con-
%         troller - i.e. u(1) corresponds to OUT1, u(2) to OUT2 ...
%         If you use UNFUZZY2 you don't have to use the INFERENZ-func-
%         tion.
%         UNFUZZY2 uses the height-method for defuzzification.
%
%		See also PREPARE.

%   Stephan Molt 01-09-93

[nr_out,rmax]=size(Rs);
u=zeros(nr_out,1);
X=0;
C=0;

for zeile=1:1:nr_out
	for spalte=1:1:rmax
		xsp=SD( zeile , Rs(zeile,spalte) );
		X=X+xsp*Aj(1,spalte);
		C=C+Aj(1,spalte);
	end
	if(abs(C)>0.001)
		u(zeile,1)=X/C;
	else
		u(zeile,1)=0;
	end
end

return
		


%----------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
