/*--------------------------------------------------------------------------
 *  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any non-commercial purpose without fee is hereby granted,
 *  provided that the above copyright notice appears in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation.
 *
 *  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 *  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 *  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 *  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 *  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 *  SOFTWARE.
 *---------------------------------------------------------------------------
 *  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE                         
 *--------------------------------------------------------------------------
 */


#include<math.h>
#include "cmex.h"


#define IN1 prhs[0]   /* erste matrix: x */
#define IN2 prhs[1]   /* d_step */

#define OUT1 plhs[0]   /* scharfe zahl */


#define min(a,b) ( (a<=b) ? a : b )
#define max(a,b) ( (a>=b) ? a : b )


user_fcn(nlhs, plhs, nrhs, prhs)
  int nlhs, nrhs;
  Matrix *plhs[], *prhs[];

  {  

  float Ai, A, M;
  float h1,h2;
  float start,ende,xx,xx1,d_step;
  int i;

  OUT1=create_matrix(1,1,REAL);
  
  /*	A - Flaecheninhalt
	    M - moment der Flaeche
      h1, h2 - seiten des trapezes
	   start, ende - anfang und ende der fuzzy-zahl
	   xx, i - laufvariable
	   old - alter wert; dient, um fehler abzufangen   */

  start=(IN1->pr)[0];
  ende=(IN1->pr)[1];
  d_step=(IN2->pr)[0];

  if( (ende-start)<d_step )
    {          
    (OUT1->pr)[0]=(ende-start)/2.;
    }
  else
     {  
     i=1;
     A=0.0;
     M=0.0;

     for(xx=start;xx<ende;xx+=d_step)
      {
      i++;

      h1=(IN1->pr)[i];
      h2=(IN1->pr)[i+1];

      Ai=0.5*(h1+h2)*d_step;	
      A=A+Ai;
      M=M+Ai*(xx+d_step/2.0);
      }   /* ende der xx-schleife */

     if(A<0.001)
        {
	(OUT1->pr)[0]=0;
        }
     else
      (OUT1->pr)[0]=M/A;

   }  /* ende des else-zweiges */
return 0;
}
