function [x0,x1]=talevel(x,k)

%TALEVEL 
%         [x0,x1]=TALEVEL(u,a) (trapezoid-alpha-level) builds the alpha-level
%         set of the fuzzy-figure 'u' with the value of alpha=a. 
%         'x0' and 'x1' are the borders of the interval in which the equation
%         mu(x) > a is fullfilled.
%         'u' must be a non-discrete fuzzy-figure.

%   Stephan Molt 01-09-93


[z,s]=size(x);
if(~(nargin==2))
   error('wrong number of arguments - TALEVEL requires two arguments')
end
if s==4,
  [n,m,alpha,beta]=copy4(x);
  ymax=1;
else
   error('fuzzy-figure must have either 4 or 5 columns; do not use a discrete figure')
end
if k>ymax,
  error('alpha-level too high; no alpha-level-set')
end

x0=(k-(alpha-n)*ymax/alpha)*alpha/ymax;
x1=-(k-(m+beta)*ymax/beta)*beta/ymax;


return


%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
