function showrule(rule,set,setdesc)

%SHOWRULE
%         showrule(rule,set,setdesc) was provided as a tool to check
%         your already designed rules.
%         If you call showrule you will be asked if you want to have a
%         look at all rules or just at a certain rule.
%         
%         (Please note, that it is possible to change (i.e. to edit)
%         rules with showrule - but I advise you to use the command
%         EDITRULE to perform this task. To withstand the temptation
%         SHOWRULE has no return-values.)

% Stephan Molt 01-09-93

if (nargin<3)
   % pruefen der argumente; 
   error('wrong number of arguments - EDITRULE requires at least three arguments');
end

% pruefen, ob objekte vom richtigen datentyp sind
[zeil,spalt]=size(rule);
[zz1,ss1]=size(set);
if(ss1~=48)
  error('the second argument must be of type SET');
end

% nachdem an dieser stelle praktisch alles richtig ist, kann losgelegt
% werden

clc;
% bestimmen, wieviele regeln es gibt
[zeil,spalt]=size(rule); 
max_rule=spalt/3;

k=input('Look at all your rules?  [y/n]','s');
if (k=='Y' | k=='y')
   for t=1:1:max_rule
      clg;
      helpshow(rule,set,setdesc,t);
      k2=input('Press [RETURN] to display next rule ','s');
   end
else
  while 1==1
   txt=['There are ',num2str(max_rule),' rules'];
   disp(txt);
   txt2=['Which rule do you want to look at?'];
   disp(txt2); 
   k3=input('Type the number and press [RETURN] ');
   if ( isstr(k3) )
      disp('Please input a number and not a string!!');
   else
      break;
   end
   if(k3>max_rule)
     txt=['The highest rule-nr is ',num2str(max_rule),'!!'];
     disp(txt);
   else
     break;
   end
  end
  clg;
  helpshow(rule,set,setdesc,k3);

end


return


%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE
 
