function f=lnf(f1)
%LNF
%         f=LNF(f1) returns the natural logarithm of 'f1',i.e. ln(f1).
%         'f1' must be a trapezoid fuzzy-figure; the result 'f' is 
%         also a trapezoid fuzzy-figure.

% Stephan Molt

if(nargin>1)
  error('wrong number of arguments - LNF requires one argument');
end

[z1,s1]= size(f1);

if (~(z1==1 & s1==4))
   error('argument must be trapezoid');
end

f(1)=log(f1(1));
f(2)=log(f1(1));
f(3)=log( f1(1) / ( f1(1)-f1(3) ) );
f(4)=log( ( f1(2)+f1(4) ) / f1(2) ) ;


return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE

