/*--------------------------------------------------------------------------
 *  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any non-commercial purpose without fee is hereby granted,
 *  provided that the above copyright notice appears in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation.
 *
 *  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 *  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 *  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 *  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 *  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 *  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 *  SOFTWARE.
 *---------------------------------------------------------------------------
 *  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE                         
 *--------------------------------------------------------------------------
 */



#include<math.h>
#include"cmex.h"

#define IN1 prhs[0] /* IN1 ist analyse-matrix */
#define IN2 prhs[1] /*IN2 ist regel-matrix*/
#define IN3 prhs[2] /* IN3 ist setdesc */
#define IN4 prhs[3] /*IN4 ist spezifikation des aggop*/

#define OUT1 plhs[0] /* enthlt aij */
#define OUT2 plhs[1] /*enthlt aggregierte ai */

#define min(a,b) ( (a<=b) ? a : b )
#define max(a,b) ( (a>=b) ? a : b )


user_fcn(nlhs, plhs, nrhs, prhs)
  int nlhs, nrhs;
  Matrix *plhs[], *prhs[];
  
  {
  int i,j,nin,rule,r,aggop;
  float gamma,alt,neu,aj;
  float safety;

  aggop=(int) (IN4->pr)[0]; 
  rule=(IN2->n)/3;
  nin=IN2->m;
  OUT1=create_matrix(nin,rule,REAL);
  OUT2=create_matrix(1,rule,REAL);
  for(j=1;j<=rule;j++)
    {
    for(i=1;i<=nin;i++)
     {
     r=(int) (IN2->pr)[i-1+(3*j-2-1)*nin];    /* entspricht rules(i,j*) */
     if(r==0)
	(OUT1->pr)[(j-1)*nin+i-1]=1.0;    /* fall fr any */
     else
        (OUT1->pr)[(j-1)*nin+i-1]=(IN1->pr)[(r-1)*nin+i-1];
     }     
    }

   for(j=1;j<=rule;j++)
      {
      safety=(IN2->pr)[(j*3-1)*nin];
      alt=1.0;	
      for(i=1;i<=nin;i++)
	{
	neu=(OUT1->pr)[(j-1)*nin+i-1];
        switch(aggop)
	    {
	    /* aggop=1:  min-op */
	    case 1:
	       alt=min(alt,neu);break;

            /* aggop=2: bounded diff s. 46*/
	    case 2:
	       alt=max(0,alt+neu-1.); break;	
	                 
            /* aggop=3: einstein prod s.46*/
	    case 3:
	       alt=alt*neu/(2.-(alt+neu-alt*neu)); break;

	    /* aggop=4: algebraic prod s.46 */
	    case 4:
	 	alt=alt*neu; break;
	    
	    /* aggop=5: hamacher prod s.46 */
	    case 5:
		if( (alt>0.001) & (neu>0.001) )
			{
			alt=(alt*neu)/(alt+neu-alt*neu); 
			}
		else
			alt=0;
		break;

	    /* aggop=6: fuzzy-and s.60*/
	    /* vorsicht: wird aggop 6 angewandt, ist aggop 6 ein
	       vektor der dim 2*1; [6 0.2], dabei gibt die 2 den wert
	       fr gamma an; vorsicht: gamma aus [0;1] */
	    case 6:
	       gamma=(IN4->pr)[1];
	       if(gamma>1) gamma = 1.0;
	       alt=gamma*min(alt,neu)+0.5*(1-gamma)*(alt+neu);break;
  	
	    default: /*fehler*/ 
	       mex_printf("\n there are only 6 aggop's at this time");
	    }
	}  /* ende i-schleife */
	(OUT2->pr)[j-1]=alt;

    /* jetzt mu noch safety und aj aggregiert werden, hier wirkt der
       gleiche operator wie oben */

       switch(aggop)
	    {
	    /* aggop=1:  min-op */
	    case 1:
	       alt=min(alt,safety);break;

	    /* aggop=2: bounded diff s. 46*/
	    case 2:
	       alt=max(0,alt+safety-1.); break;	
			 
	    /* aggop=3: einstein prod s.46*/
	    case 3:
	       alt=alt*safety/(2.-(alt+safety-alt*safety)); break;

	    /* aggop=4: algebraic prod s.46 */
	    case 4:
		alt=alt*safety; break;
	    
	    /* aggop=5: hamacher prod s.46 */
	    case 5:
		alt=(alt*safety)/(alt+safety-alt*safety); break;

	    /* aggop=6: fuzzy-and s.60*/
	    /* vorsicht: wird aggop 6 angewandt, ist aggop 6 ein
	       vektor der dim 2*1; [6 0.2], dabei gibt die 2 den wert
	       fr gamma an; vorsicht: gamma aus [0;1] */
	    case 6:
	       gamma=(IN4->pr)[1];
	       if(gamma>1) gamma = 1.0;
	       alt=gamma*min(alt,safety)+0.5*(1-gamma)*(alt+safety);break;
	}
		
       (OUT2->pr)[j-1]=alt;			
    }  /* ende j-schleife */
  
  return 0;
  }  /* hier endet user-fcn */
