function [mu]=discret(a,d_step)

%DISCRET(x)
%         [xd]=DISCRET(x,d_step) builds a discrete fuzzy-figure 'xd' 
%         that corresponds to the figure 'x', but which is now discrete.
%         'd_step' describes the discrete steps between two points of the 
%         fuzzy-figure. 

% Stephan Molt 01-09-93

[z,s1]=size(a);
% zuerst: argumente pruefen

if (s1>4)
   error('fuzzy-figure already discrete or non-trapezoid')
end

if (nargin~=2)
   error('wrong number of arguments - DISCRET requires two arguments')
end

if(s1==4)
  [n,m,alpha,beta]=copy4(a);
  ymax=1.0;
elseif (s1==5)
  [n,m,alpha,beta,ymax]=copy5(a);
end

start=n-alpha;
ziel=m+beta;
	

mu=[start,ziel];

% eigentliche diskretisierung
for i=start:d_step:n
	f=(alpha-n+i)*ymax/alpha;
	mu=[mu,f];
end
for i=n+d_step:d_step:m
	mu=[mu,ymax];
end
for i=m+d_step:d_step:m+beta
	f=(m+beta-i)*ymax/beta;
	mu=[mu,f];
end



return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE

