function t=colid(i)

%COLID(i)
%         T=COLID(i) (colour_id) returns a string, containing a
%         colour-code. This string can be used for calling the 
%         function PLOT so that the user can distinguish different 
%         plots. It is now possible to use COLID in a FOR-END-loop, 
%         whose index is a colour-code.
%         The identifiers range from 1 to 20 and are defined as:
%
%         i=1	   RED		i=11	.  GREEN
%         i=2	   GREEN	i=12	+  GREEN
%         i=3	   BLUE		i=13	o  GREEN
%         i=4	   WHITE	i=14	*  GREEN
%         i=5	-- RED		i=15	-- BLUE
%         i=6	.  RED		i=16    .  BLUE
%         i=7	+  RED		i=17	+  BLUE
%         i=8	o  RED		i=18 	o  BLUE
%         i=9	*  RED		i=19	*  BLUE
%         i=10	-- GREEN	i=20	-- WHITE

% Stephan Molt

if(i<1 | i>20)
  error('color-identifier must be between 1 and 20, each including');
end
if(nargin>1)
  error('wrong number of arguments - COLID requires one argument')
end
if(i==1)
	t='-r';
end
if(i==2)
	t='-g';
end
if(i==3)
	t='-b';
end
if(i==4)
	t='-w';
end
if(i==5)
	t='--r';
end
if(i==6)
	t='.r';
end
if(i==7)
	t='+r';
end
if(i==8)
	t='or';
end
if(i==9)
	t='*r';
end
if(i==10)
	t='--g';
end
if(i==11)
	t='.g';
end
if(i==12)
	t='+g';
end
if(i==13)
	t='og';
end
if(i==14)
	t='*g';
end
if(i==15)
	t='--b';
end
if(i==16)
	t='.b';
end
if(i==17)
	t='+b';
end
if(i==18)
	t='ob';
end
if(i==19)
	t='*b';
end
if(i==20)
	t='--w';
end


return

%------------------------------------------------------------------------------
%  Copyright (c) 1994, University of Stuttgart, IFR, All rights reserved.
%
%  Permission to use, copy, modify, and distribute this software and its
%  documentation for any non-commercial purpose without fee is hereby granted,
%  provided that the above copyright notice appears in all copies and that
%  both that copyright notice and this permission notice appear in
%  supporting documentation.
% 
%  THE IFR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
%  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
%  THE IFR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
%  ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
%  WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
%  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
%  SOFTWARE.
%---------------------------------------------------------------------------
%  email:Postmaster@IFR.Luftfahrt.Uni-Stuttgart.DE





