%	Animation of two generalized bell membership functions.

%	Copyright (c) 1993 Jyh-Shing Roger Jang, U. C. Berkeley
%	jang@eecs.berkeley.edu
%	(Tested on Matlab version 4.0a, HP workstation)
%	Permission is granted to modify and re-distribute this code
%	in any manner as long as this notice is preserved.
%	All standard disclaimers apply.

%	7-4-93.

echo on;
clc;

% This file shows how two generalized bell functions change their widths,
% centers and midpoing slopes as their three parameters (a, b, c) changes.

echo off;

clg;
set(gcf, 'position', [10 544 560 420]);

x = (-10:0.2:10)';
% An arbitrary plot
p = plot([-10, 10], [0 1; 1 0]);
% To initialize the xlabel and title field of current axes
xlabel(''); title('');
axis([-10 10 0 1]);
set(p,'erasemode','xor')
% If not initialized previously, t1 and t2 will be NULL
t1 = get(gca, 'xlabel'); set(t1, 'EraseMode', 'xor');
t2 = get(gca, 'title'); set(t2, 'EraseMode', 'xor');

for i=0:0.02:10,
	if i == 0,
		set(p(1), 'XData', x)
		set(p(2), 'XData', x)
	end
	a1 = 3;
	b1 = 4*sin(i);
	c1 = 5*cos(i);
	y = bell(x, a1, b1, c1);
	set(p(1), 'YData', y)
	a2 = 6;
	b2 = 4*sin(i+pi/2);
	c2 = 5*cos(i+pi/2);
	y = bell(x, a2, b2, c2);
	set(p(2), 'YData', y)
	text1 = sprintf('yellow curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)', a1, b1, c1);
	set(t1, 'string', text1);
	text2 = sprintf('red curve: (a, b, c) = (%6.2f, %6.2f, %6.2f)', a2, b2, c2);
	set(t2, 'string', text2);
	drawnow
end
