(***************************************************************************************)
(* module name: Tools                                                                  *)
(* project: simulation of a fuzzy pathplanning algorithm                               *)
(* author: markus stadler, IIIC/8                                                      *)
(* first implementation: 6/21/91                                                       *)
(* last change         : 7/12/91                                                       *)
(***************************************************************************************)

IMPLEMENTATION MODULE Tools;

FROM Dialog  IMPORT Dialog, TextStyle, New, Open, Close, Dispose, UserAction, Button,
                    StaticString, Rectangle;
FROM System  IMPORT GetScreen, Allocate, Deallocate;
FROM String  IMPORT Length, Append, AppendCh, MakePascalString;
             IMPORT TextWindows, TerminalIn, FileSystem;

(* definition of constants *)
CONST
  boxHeight    =   80;   (* height of message box *)
  
(* definition of types *)

TYPE
  Str255 = ARRAY [0..255] OF CHAR;
  
(* definition of global variables *)

VAR
  xScreen, yScreen: INTEGER; (* dummy parameters for procedure System.GetScreen *)

(* utility procedures *)

(* exported procedures *)

(* declaration of ToolBox procedures *)
PROCEDURE StringWidth(VAR s: Str255):INTEGER;      CODE 0A88CH;

PROCEDURE ShowString(string: ARRAY OF CHAR);  (*--------------------------------------*)
CONST
  offsetX = 25;
VAR
  d:          Dialog;
  b, item:    INTEGER;
  pascalStr:  Str255;
  w:          INTEGER;
BEGIN
  MakePascalString(string, pascalStr);
  w:=2*offsetX+StringWidth(pascalStr);
  IF w>wScreen-80 THEN w:= wScreen-80 END; 
  New(d, (wScreen-w-32) DIV 2, (hScreen-boxHeight) DIV 2, w+32, boxHeight);
  StaticString(d, string, offsetX, 50, Plain);
  Button(d, b, TRUE, (w DIV 2) - offsetX, 10, "OK");
  Open(d);
  LOOP
    IF UserAction(d, item) THEN
      IF item=b THEN EXIT END
    END; (* IF *)
  END; (* IF *)
  Close(d);
  Dispose(d);
END ShowString;


PROCEDURE ShowFile(filename: ARRAY OF CHAR);
CONST
  maxChar       =  256;
  EOL           =  15C;
  leftOffset    =  24;
  rightOffset   =  24;
  minWidth      =  200;
  charHeight    =  14;
  controlHeight =  50;
TYPE
  Line     =  POINTER TO LineDesc;
  LineDesc = RECORD
               s:    Str255;
               next: Line;
             END; (* RECORD *)
VAR
  firstLine,
  line:       Line;
  f:          FileSystem.File;
  string:     Str255;
  width, 
  maxWidth:   INTEGER;
  height:     INTEGER;
  i, noLines, 
  maxLines:   INTEGER;
  ch:         CHAR;
  clipped:    BOOLEAN;
  
  d:          Dialog;
  up, 
  down,
  ok,
  item:       INTEGER;
  wasAction:  BOOLEAN;
  
BEGIN
  FileSystem.Lookup(f, filename, FALSE);
  IF f.res = FileSystem.done THEN
    (* read file line by line *)
    Allocate(firstLine, SIZE(LineDesc));
    firstLine^.next:= NIL;
    line:= firstLine;
    noLines:= 1; i:= 0;
    (* for all lines do *)
    FileSystem.ReadChar(f, ch);
    WHILE ch # 0C DO
      IF ch = EOL THEN
        IF i<maxChar THEN line^.s[i]:= 0C END;
        Allocate(line^.next, SIZE(LineDesc));
        i:= 0;
        line:= line^.next; line^.next:= NIL;
        INC(noLines);
      ELSE
        IF i<maxChar THEN
          line^.s[i]:= ch;
          INC(i);
        END; (* IF *)
      END; (* IF *)
      FileSystem.ReadChar(f, ch);
    END; (* WHILE *)
    IF i<maxChar THEN line^.s[i]:= 0C END;
    FileSystem.Close(f);
    
    (* calculate maximal widht of text in pixels *)
    maxWidth:= minWidth;
    line:= firstLine;
    WHILE line # NIL DO
      MakePascalString(line^.s, string);
      width:= StringWidth(string);
      IF width > maxWidth THEN maxWidth:= width END;
      line:= line^.next;
    END; (* WHILE *)
    
    IF maxWidth+leftOffset+rightOffset>wScreen-10 THEN
      maxWidth:= wScreen-10-leftOffset-rightOffset;
    END; (* IF *)
    maxLines:= (hScreen-controlHeight-32-100) DIV charHeight;
    clipped:= noLines>maxLines;
    IF clipped THEN noLines:= maxLines END;
    height:= noLines*charHeight+controlHeight;
    
    (* open dialog *)
    New(d, (wScreen-100-leftOffset-rightOffset-maxWidth) DIV 2,
           (hScreen-height) DIV 2,
           maxWidth+leftOffset+rightOffset,
           height+16);
    (* line betwenn text and control section *)
    Rectangle(d, leftOffset-16, controlHeight, maxWidth, 1);
    (* insert buttons *)
    Button(d, ok, TRUE, leftOffset-16+maxWidth DIV 2-25, 8, "Ok");
    (* if text was clipped, write a propriate message *)
    IF clipped THEN
      StaticString(d, "remaining part of text ignored",
                    leftOffset-16, controlHeight-charHeight-2, Italic);
    END; (* IF *)
    (* show strings *)
    i:= 1;
    line:= firstLine;
    WHILE (i<=noLines) AND (line # NIL) DO
      StaticString(d, line^.s, leftOffset-16, height-i*charHeight, Plain);
      INC(i); line:= line^.next;
    END; (* WHILE *)
    
    Open(d);
    (* wait for user actions *)
    REPEAT
      wasAction:= UserAction(d, item);
    UNTIL wasAction AND (item = ok);
    Close(d);
    Dispose(d);
    
    (* deallocating memory *)
    WHILE firstLine # NIL DO
      line:=  firstLine;
      firstLine:= firstLine^.next;
      Deallocate(line);
    END; (* WHILE *)
  ELSE
    ShowString("file open  error; click 'Ok' to continue");
  END; (* IF *)
END ShowFile;

BEGIN
  GetScreen(xScreen, yScreen, wScreen, hScreen);
END Tools.