/* $RCSfile: truck-world.c,v $ $Date: 1993/08/05 03:51:54 $ $Revision: 1.11 $ */
/* by G.K. Egan + A. Sekercioglu,                                       */    
/* The Laboratory for Concurrent Computing Systems,                     */  
/* Swinburne University of Technology, Melbourne, Australia             */
/* for correspondence: Ahmet Sekercioglu ( yas@swin.oz.au )             */

#include <stdio.h>

#include "hlnfs.h"
#include "flie.h"
#include "truck.h"

#define COPYRIGHT "Copyright (C) G.K. Egan + A. Sekercioglu 1993"

/* prototypes of local functions:  */
/* (none at the moment)            */

/* function-block wide global declarations: */
static char rcs_id[]="$Id: truck-world.c,v 1.11 1993/08/05 03:51:54 yas Exp $";

int main( argc, argv )
     int argc;
     char *argv[];
{
  FILE *rule_file = NULL;
  FILE *initial_state_file = NULL;
  ModelVarsIdStruct model_var_ids;
  extern int optind;
  extern int opterr;
  int iteration = 0;
  int c;
  extern char *optarg;
  char *cmd;
  char *rule_file_name = NULL;
  char *initial_state_file_name = NULL;

  cmd = argv[0]; /* name of the program */
  while ( ( c = getopt( argc, argv, "r:s:" ) ) != EOF ) {
    switch( c )	{
    case 'r':
      rule_file_name = optarg;
      break;
    case 's':
      initial_state_file_name = optarg;
      break;
    case '?':
      printf("%s %s \n", __FILE__, "error : unrecognized/invalid option" );
      exit ( -1 );
    } /* switch */
  } /* while */
  if ( rule_file_name == NULL ) {
    rule_file_name = "truck-rules.dat";
  } /* if */
  if ( ( rule_file = fopen( rule_file_name, "r" ) ) == NULL ) {
    perror( rule_file_name );
    exit ( -1 );
  } /* if */
  if ( ! ( LoadRuleBase( rule_file ) ) ) {
    printf("%s %s \n", __FILE__, "error : Load errors" );
    exit ( -1 );
  } /* if */
  if ( !IdentifyModelVariables( &model_var_ids ) ) {
    printf( "%s error : could not identify the variable(s)\n", __FILE__ );
    exit ( -1 );
  } /* if */
  if ( initial_state_file_name == NULL ) {
    initial_state_file_name = "truck-initial-state.dat";
  } /* if */
  if ( ( initial_state_file = fopen(initial_state_file_name, "r") ) == NULL ) {
    perror( initial_state_file_name );
    exit ( -1 );
  } /* if */
  InitModel( initial_state_file, &model_var_ids );
  printf( "%s info : Loaded OK\n", __FILE__ );
  if ( !IdentifyModelVariables( &model_var_ids ) ) {
    printf( "__FILE__ error : could not identify the variable(s)\n" );
    exit ( -1 );
  } /* if */
  InitModel( initial_state_file, &model_var_ids );
  do {
    DumpCurrentValues();
    FuzzyInferenceEngine();
    Model( &model_var_ids );
    iteration++;
  } while ( !GoalAchieved( &model_var_ids ) );
  exit ( 0 );
}  /* main */





