/* $Id: flie.h,v 1.15 1993/08/05 03:51:54 yas Exp $                 */
/*                                                                      */
/* adapted from the original flie of Institute of Robotics, ETH, Zurich */
/*                                                                      */
/* by G.K. Egan + A. Sekercioglu,                                       */    
/* The Laboratory for Concurrent Computing Systems,                     */  
/* Swinburne University of Technology, Melbourne, Australia             */
/* for correspondence: Ahmet Sekercioglu ( yas@swin.oz.au )             */

#ifdef EXPLAIN
#define GiveExplanation TRUE
#else
#define GiveExplanation FALSE
#endif

/* Fuzzy Logic Inference Engine Limits */
#define INDECISION_THRESHOLD 	0.0
#define RULE_THRESHOLD 		0.01
#define MAX_INFLEX              64
#define MAX_CLASSES             32
#define MAX_SYN        	        2
#define MAX_ANTE                32
#define MAX_RULES               256
#define NULL_RULE               (-1)
#define MAX_VARIABLES           64

typedef struct SynonymRec {
  double a, b, c, d, ClassArea, ClassMoment, ClassYMoment,ClassXMoment;
} SynonymRec;

typedef struct ClassRec {
  int DominantRule;
  int NewSyn;
  int CurrSyn;
  boolean Mentioned;
  int NoInflexions;
  int NoSynonyms;
  SynonymRec Synonym[MAX_SYN];
  int   ClassName;
  double ClassArea;          /* Calculated in the LoadRuleBase phase,    */
                             /* used only for fuzzy classes which are in */
                             /* the term set of the output variable(s).  */

  double ClassYMoment;       /* Moment of the class with respect to Y    */
			     /* axis.                                    */
                             /* Calculated in the LoadRuleBase phase,    */
			     /* used only for fuzzy classes which are in */
			     /* the term set of the output variable(s).  */

  double ClassXMoment;       /* Moment of the class with respect to X    */
                             /* axis.                                    */
                             /* Calculated in the LoadRuleBase phase,    */
			     /* used only for fuzzy classes which are in */
			     /* the term set of the output variable(s).  */

  double NewClassStrength;
  double CurrClassStrength;  /* fit value of the variable for this class */
                             /* ( fuzzy membership value of the current  */
                             /* crisp value of the variable )            */
                             /* ( used only for input variables )        */
  int   NoOfInflexions;
  double Inflex[MAX_INFLEX];
} ClassRec;

typedef ClassRec ClassArray[MAX_CLASSES];

typedef struct VarRec {
  int VarName;
  enum { InputVar, OutputVar } VarKind;
  int NoClasses;
  double CurrVal;
  double MaxSlewRate;        /* Maximum change which may occur to a     */
                             /* variable due to some physical limit     */
                             /* e.g. a servoe motor's power             */
  double FailSafe;           /* Value to which the variable should be   */
                             /* set if no rule applies                  */
  double CurrValConf;        /* Used only for output variables.         */
                             /* After visiting all the rules, the       */
                             /* system confidence related to the New    */
                             /* value for this variable is calculated   */
                             /* by finding the                          */
                             /* Y-coordinate of the centroid =          */  
			     /*    TotalXMoments / TotalArea            */    
  double TotalMoments;       /* Used only for output variables. Moments */
                             /* of the fuzzy classes involving this     */
                             /* variable are accumulated here after     */
                             /* scaling them with the rule strength.    */
  double TotalAreas;         /* Used only for output variables. Areas   */
                             /* of the fuzzy classes involving this     */
                             /* variable are accumulated here after     */
                             /* scaling them with the rule strength.    */
                             /*                                         */
                             /* After visiting all the rules, the crisp */
                             /* value for this variable is calculated   */
                             /* by finding the                          */
                             /* X-coordinate of the centroid =          */  
			     /*    TotalMoments / TotalAreas            */    
  double VarLowerB;          
  double VarUpperB;
  ClassArray Class;
} VarRec;

typedef VarRec VarArray[MAX_VARIABLES];

/* system-wide global functions: */
extern boolean LoadRuleBase( FILE *RuleFile);
extern void FuzzyInferenceEngine();
extern boolean FoundVar( char *var_ident, int *N );
extern void DumpCurrentValues();
extern void UpdateAdaptationWeights( vector *v );

/* system-wide global variables: */
VarArray Variables;
extern int NoVars;         /* filled by LoadRuleBase() */
extern int NoRules;        /* filled by LoadRuleBase() */
extern int NoInputVars;    /* filled by LoadRuleBase() */
