function [W]=similar(dA,dAp,n)
%SIMILAR: Similarity Measure: This function manipulate the similarity
%         measure between matrix of fuzzy value A and vector of observed 
%         value Ap. A and Ap must be defined over the same universe (the 
%         number of column of matrix A must be equal to length Ap). The 
%         method of similarity N obtained in this function is selected 
%         from the following list. The output is the vector of similarity 
%         W for each rule.
%
%                [W] = SIMILAR(A,Ap,N)
%
%         N is selected from following list.(default N=1)
%
%         1: Dis-consistency Measure
%         2: Euclidean Distance


% FISMAT: Fuzzy Inference Systems toolbox for MATLAB
% (c) A. Lotfi, University of Queensland (Email: lotfia@s1.elec.uq.oz.au)
% 13-10-93
% The program has been tested on MATLAB version 4.1, Sun workstation.


if nargin < 3, n=1; end

if (max(max(dA)) > 1) | (min(min(dA)) < 0)
error('Grade of membership should not be greater than 1 or less than zero.')
end

if (max(max(dAp)) > 1) | (min(min(dAp)) < 0)
error('Grade of membership should not be greater than 1 or less than zero.')
end

if n == 1

        Ap=ones(size(dA)) * diag(dAp);
        D=(1-(max(intersec(dA,Ap)')))';

elseif n == 2

        [rule q]=size(dA);

                for i=1:rule
                D(i)=sqrt(sum(sum((dA(i,:)-dAp) .^ 2))/q);
                end
        D=D(:);
else
        error('Method of similarity measure is not proper');
end

W=1 ./ (1+D);
